/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.reward.lib.core;

import cn.handyplus.reward.lib.core.NumberUtil;
import cn.handyplus.reward.lib.core.PatternUtil;
import cn.handyplus.reward.lib.core.StrUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;

public class FormulaUtil {
    private static final String TEMPLATE_EXPRESSION_VALUE = "TEMPLATE_EXPRESSION_VALUE";

    private FormulaUtil() {
    }

    public static Long evaluateFormulaToLong(String formula, Map<String, String> map) {
        return NumberUtil.isNumericToLong(FormulaUtil.evaluateFormula(formula, map), 0L);
    }

    public static Double evaluateFormulaToDouble(String formula, Map<String, String> map) {
        return NumberUtil.isNumericToDouble(FormulaUtil.evaluateFormula(formula, map), 0.0);
    }

    public static Integer evaluateFormulaToInt(String formula, Map<String, String> map) {
        return FormulaUtil.evaluateFormulaToDouble(formula, map).intValue();
    }

    public static String evaluateFormula(String formula, Map<String, String> map) {
        Matcher matcher = PatternUtil.TEMPLATE_EXPRESSION_REGEX.matcher(formula);
        while (matcher.find()) {
            String variable = matcher.group(1);
            formula = StrUtil.replace(formula, variable, TEMPLATE_EXPRESSION_VALUE);
            for (String key : map.keySet()) {
                variable = variable.replace(key, map.get(key));
            }
            String result = FormulaUtil.calculateExpression(variable);
            formula = formula.replace(TEMPLATE_EXPRESSION_VALUE, result);
        }
        return formula;
    }

    private static String calculateExpression(String expression) {
        String rpn = FormulaUtil.toRPN(expression);
        return String.valueOf(FormulaUtil.calculateRPN(rpn));
    }

    private static String toRPN(String expression) {
        StringBuilder rpn = new StringBuilder();
        Stack<Character> stack = new Stack<Character>();
        for (int i = 0; i < expression.length(); ++i) {
            char c = expression.charAt(i);
            if (c == ' ') continue;
            if (Character.isDigit(c)) {
                while (i < expression.length() && (Character.isDigit(expression.charAt(i)) || expression.charAt(i) == '.')) {
                    rpn.append(expression.charAt(i));
                    ++i;
                }
                rpn.append(' ');
                --i;
                continue;
            }
            if (c == '(') {
                stack.push(Character.valueOf(c));
                continue;
            }
            if (c == ')') {
                while (!stack.isEmpty() && ((Character)stack.peek()).charValue() != '(') {
                    rpn.append(stack.pop()).append(' ');
                }
                stack.pop();
                continue;
            }
            if (!FormulaUtil.isOperator(c)) continue;
            while (!stack.isEmpty() && FormulaUtil.getPriority(((Character)stack.peek()).charValue()) >= FormulaUtil.getPriority(c)) {
                rpn.append(stack.pop()).append(' ');
            }
            stack.push(Character.valueOf(c));
        }
        while (!stack.isEmpty()) {
            rpn.append(stack.pop()).append(' ');
        }
        return rpn.toString();
    }

    private static boolean isOperator(char c) {
        return c == '+' || c == '-' || c == '*' || c == '/';
    }

    private static int getPriority(char operator) {
        switch (operator) {
            case '+': 
            case '-': {
                return 1;
            }
            case '*': 
            case '/': {
                return 2;
            }
        }
        return 0;
    }

    private static double calculateRPN(String rpn) {
        String[] tokens;
        Stack<Double> stack = new Stack<Double>();
        for (String token : tokens = rpn.split(" ")) {
            if (FormulaUtil.isNumber(token)) {
                stack.push(Double.parseDouble(token));
                continue;
            }
            if (!FormulaUtil.isOperator(token.charAt(0))) continue;
            double operand2 = (Double)stack.pop();
            double operand1 = (Double)stack.pop();
            double result = FormulaUtil.performOperation(operand1, operand2, token.charAt(0));
            stack.push(result);
        }
        return (Double)stack.pop();
    }

    private static boolean isNumber(String token) {
        try {
            Double.parseDouble(token);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static double performOperation(double operand1, double operand2, char operator) {
        BigDecimal bigDecimalOperand1 = BigDecimal.valueOf(operand1);
        BigDecimal bigDecimalOperand2 = BigDecimal.valueOf(operand2);
        switch (operator) {
            case '+': {
                return bigDecimalOperand1.add(bigDecimalOperand2).doubleValue();
            }
            case '-': {
                return bigDecimalOperand1.subtract(bigDecimalOperand2).doubleValue();
            }
            case '*': {
                return bigDecimalOperand1.multiply(bigDecimalOperand2).doubleValue();
            }
            case '/': {
                if (operand2 == 0.0) {
                    throw new RuntimeException("\u9664\u6570\u4e0d\u80fd\u4e3a0");
                }
                return bigDecimalOperand1.divide(bigDecimalOperand2, 2, RoundingMode.HALF_UP).doubleValue();
            }
        }
        throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u8fd0\u7b97\u7b26: " + operator);
    }
}

