/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.reward.lib.core;

import cn.handyplus.reward.lib.core.PatternUtil;
import cn.handyplus.reward.lib.core.StrUtil;
import cn.handyplus.reward.lib.util.AssertUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Optional;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;

public class NumberUtil {
    private NumberUtil() {
    }

    public static Integer isNumericToInt(@NotNull String str) {
        return NumberUtil.isNumericToInt(str, null);
    }

    public static Integer isNumericToInt(@NotNull String str, Integer def) {
        return NumberUtil.isNumericToBigDecimal(str).map(BigDecimal::intValue).orElse(def);
    }

    public static Double isNumericToDouble(@NotNull String str) {
        return NumberUtil.isNumericToDouble(str, null);
    }

    public static Double isNumericToDouble(@NotNull String str, Double def) {
        return NumberUtil.isNumericToBigDecimal(str).map(BigDecimal::doubleValue).orElse(def);
    }

    public static Long isNumericToLong(@NotNull String str) {
        return NumberUtil.isNumericToLong(str, null);
    }

    public static Long isNumericToLong(@NotNull String str, Long def) {
        return NumberUtil.isNumericToBigDecimal(str).map(BigDecimal::longValue).orElse(def);
    }

    public static Optional<BigDecimal> isNumericToBigDecimal(@NotNull String str) {
        return Optional.ofNullable(NumberUtil.isNumericToBigDecimal(str, null));
    }

    public static BigDecimal isNumericToBigDecimal(@NotNull String str, BigDecimal def) {
        if (StrUtil.isEmpty(str)) {
            return def;
        }
        try {
            Matcher isNum = PatternUtil.BIG_DECIMAL_NUMERIC.matcher(str);
            if (isNum.matches()) {
                return new BigDecimal(str);
            }
        }
        catch (NumberFormatException e) {
            return def;
        }
        return def;
    }

    public static BigDecimal mul(@NotNull BigDecimal num1, @NotNull BigDecimal num2) {
        BigDecimal rawResult = num1.multiply(num2);
        int scale = rawResult.scale();
        return scale > 2 ? rawResult.setScale(2, RoundingMode.HALF_UP) : rawResult;
    }

    public static BigDecimal div(@NotNull BigDecimal num1, @NotNull BigDecimal num2) {
        return num1.divide(num2, 2, RoundingMode.HALF_UP);
    }

    public static boolean lt(@NotNull BigDecimal num1, @NotNull BigDecimal num2) {
        return num1.compareTo(num2) < 0;
    }

    public static boolean le(@NotNull BigDecimal num1, @NotNull BigDecimal num2) {
        return num1.compareTo(num2) <= 0;
    }

    public static boolean gt(@NotNull BigDecimal num1, @NotNull BigDecimal num2) {
        return num1.compareTo(num2) > 0;
    }

    public static boolean ge(@NotNull BigDecimal num1, @NotNull BigDecimal num2) {
        return num1.compareTo(num2) >= 0;
    }

    public static BigDecimal toBigDecimal(Number number) {
        if (null == number) {
            return BigDecimal.ZERO;
        }
        AssertUtil.isTrue(NumberUtil.isValidNumber(number), "Number is invalid!");
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        if (number instanceof Long) {
            return new BigDecimal((Long)number);
        }
        if (number instanceof Integer) {
            return new BigDecimal((Integer)number);
        }
        if (number instanceof BigInteger) {
            return new BigDecimal((BigInteger)number);
        }
        return new BigDecimal(number.toString());
    }

    public static boolean isValidNumber(Number number) {
        if (null == number) {
            return false;
        }
        if (number instanceof Double) {
            return !((Double)number).isInfinite() && !((Double)number).isNaN();
        }
        if (number instanceof Float) {
            return !((Float)number).isInfinite() && !((Float)number).isNaN();
        }
        return true;
    }
}

