/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.reward.lib.core;

import cn.handyplus.reward.lib.core.PatternUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.stream.Collectors;

public class StrUtil {
    private StrUtil() {
    }

    public static boolean isEmpty(CharSequence str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNotEmpty(CharSequence str) {
        return !StrUtil.isEmpty(str);
    }

    public static String toLowerCase(String str) {
        return str != null ? str.toLowerCase() : null;
    }

    public static String replaceSpace(String str) {
        if (StrUtil.isEmpty(str)) {
            return str;
        }
        return str.replace("#", " ");
    }

    public static List<String> strToStrList(String str) {
        return StrUtil.strToStrList(str, ",");
    }

    public static List<String> strToStrList(String str, String split) {
        ArrayList<String> list = new ArrayList<String>();
        if (StrUtil.isEmpty(str)) {
            return list;
        }
        return Arrays.stream(str.split(split)).map(String::trim).collect(Collectors.toList());
    }

    public static List<Long> strToLongList(String str) {
        ArrayList<Long> list = new ArrayList<Long>();
        if (StrUtil.isEmpty(str)) {
            return list;
        }
        return Arrays.stream(str.split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
    }

    public static List<Integer> strToIntList(String str) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        if (StrUtil.isEmpty(str)) {
            return list;
        }
        return Arrays.stream(str.split(",")).map(s -> Integer.valueOf(s.trim())).collect(Collectors.toList());
    }

    public static String lineToHump(String str) {
        str = str.toLowerCase();
        Matcher matcher = PatternUtil.LINE_PATTERN.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, matcher.group(1).toUpperCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String humpToLine(String str) {
        Matcher matcher = PatternUtil.HUMP_PATTERN.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "_" + matcher.group(0).toLowerCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String deleteWhitespace(String str) {
        if (StrUtil.isEmpty(str)) {
            return str;
        }
        int sz = str.length();
        char[] chs = new char[sz];
        int count = 0;
        for (int i = 0; i < sz; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            chs[count++] = str.charAt(i);
        }
        if (count == sz) {
            return str;
        }
        return new String(chs, 0, count);
    }

    public static String replace(String str, String format, String value) {
        if (StrUtil.isEmpty(str) || StrUtil.isEmpty(format)) {
            return str;
        }
        return str.replace("${" + format + "}", value);
    }

    public static boolean equals(CharSequence str1, CharSequence str2) {
        if (null == str1) {
            return str2 == null;
        }
        if (null == str2) {
            return false;
        }
        return str1.toString().contentEquals(str2);
    }

    public static String replaceLast(String text, String regex, String replacement) {
        int lastIndex = text.lastIndexOf(regex);
        if (lastIndex != -1) {
            return text.substring(0, lastIndex) + replacement + text.substring(lastIndex + regex.length());
        }
        return text;
    }
}

