/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.reward.lib.db;

import cn.handyplus.reward.lib.InitApi;
import cn.handyplus.reward.lib.constants.BaseConstants;
import cn.handyplus.reward.lib.core.StrUtil;
import cn.handyplus.reward.lib.db.DbTypeEnum;
import cn.handyplus.reward.lib.expand.zaxxer.hikari.HikariConfig;
import cn.handyplus.reward.lib.expand.zaxxer.hikari.HikariDataSource;
import cn.handyplus.reward.lib.util.HandyConfigUtil;
import cn.handyplus.reward.lib.util.MessageUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import org.bukkit.Bukkit;

public class SqlManagerUtil {
    private static final SqlManagerUtil INSTANCE = new SqlManagerUtil();
    public static final String STORAGE_METHOD = "storage-method";
    private HikariDataSource ds;

    private SqlManagerUtil() {
    }

    public static SqlManagerUtil getInstance() {
        return INSTANCE;
    }

    public void enableSql() {
        this.enableSql(null);
    }

    public void enableSql(String storageMethod) {
        BaseConstants.STORAGE_CONFIG = HandyConfigUtil.load("storage.yml");
        this.close();
        this.enableTable(storageMethod);
    }

    private void enableTable(String storageMethod) {
        if (StrUtil.isEmpty(storageMethod)) {
            storageMethod = this.getStorageMethod();
        }
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setPoolName((InitApi.PLUGIN != null ? InitApi.PLUGIN.getName() : "HandyLib") + "HikariPool");
        if (DbTypeEnum.MySQL.getType().equalsIgnoreCase(storageMethod)) {
            String host = BaseConstants.STORAGE_CONFIG.getString("MySQL.Host");
            String database = BaseConstants.STORAGE_CONFIG.getString("MySQL.Database");
            int port = BaseConstants.STORAGE_CONFIG.getInt("MySQL.Port");
            String useSsl = BaseConstants.STORAGE_CONFIG.getString("MySQL.UseSSL");
            String param = BaseConstants.STORAGE_CONFIG.getString("MySQL.param", "");
            String jdbcUrl = "jdbc:mysql://" + host + ":" + port + "/" + database + "?useSSL=" + useSsl + "&useUnicode=true&characterEncoding=UTF-8&rewriteBatchedStatements=true" + param;
            hikariConfig.setJdbcUrl(jdbcUrl);
            hikariConfig.setUsername(BaseConstants.STORAGE_CONFIG.getString("MySQL.User"));
            hikariConfig.setPassword(BaseConstants.STORAGE_CONFIG.getString("MySQL.Password"));
            this.setCustomConfig(hikariConfig);
        } else {
            String jdbcUrl = InitApi.PLUGIN != null ? "jdbc:sqlite:" + InitApi.PLUGIN.getDataFolder().getAbsolutePath() + "/" + InitApi.PLUGIN.getName() + ".db" : "jdbc:sqlite:HandyLib.db";
            hikariConfig.setDriverClassName("org.sqlite.JDBC");
            hikariConfig.setConnectionTestQuery("SELECT 1");
            hikariConfig.setJdbcUrl(jdbcUrl);
        }
        this.ds = new HikariDataSource(hikariConfig);
    }

    protected Connection getConnection(String storageMethod) {
        if (StrUtil.isEmpty(storageMethod)) {
            storageMethod = this.getStorageMethod();
        }
        if (this.ds == null || this.ds.isClosed()) {
            MessageUtil.sendConsoleDebugMessage(" HikariDataSource \u94fe\u63a5\u5f02\u5e38\u5173\u95ed\uff0c\u91cd\u65b0\u6253\u5f00");
            this.enableTable(storageMethod);
        }
        try {
            return this.ds.getConnection();
        }
        catch (SQLException e) {
            Bukkit.getLogger().log(Level.SEVERE, "getConnection \u53d1\u751f\u5f02\u5e38", e);
            throw new RuntimeException(e);
        }
    }

    protected void quietSetAutoCommit(Connection conn, Boolean autoCommit) {
        if (null != conn && null != autoCommit) {
            try {
                conn.setAutoCommit(autoCommit);
            }
            catch (Exception e) {
                Bukkit.getLogger().log(Level.SEVERE, "quietSetAutoCommit \u53d1\u751f\u5f02\u5e38", e);
            }
        }
    }

    protected void closeSql(Connection conn, PreparedStatement ps, ResultSet rst) {
        try {
            if (rst != null) {
                rst.close();
            }
            if (ps != null) {
                ps.close();
            }
            if (conn != null && conn.getAutoCommit()) {
                conn.close();
            }
        }
        catch (SQLException e) {
            Bukkit.getLogger().log(Level.SEVERE, "closeSql \u53d1\u751f\u5f02\u5e38", e);
        }
    }

    public void close() {
        if (this.ds != null) {
            this.ds.close();
        }
    }

    protected String getStorageMethod() {
        if (BaseConstants.STORAGE_CONFIG == null) {
            return DbTypeEnum.SQLite.getType();
        }
        String storageMethod = BaseConstants.STORAGE_CONFIG.getString(STORAGE_METHOD);
        if (DbTypeEnum.MySQL.getType().equalsIgnoreCase(storageMethod)) {
            return DbTypeEnum.MySQL.getType();
        }
        return DbTypeEnum.SQLite.getType();
    }

    private void setCustomConfig(HikariConfig hikariConfig) {
        int connectionTimeout;
        int minimumIdle;
        int maximumPoolSize = BaseConstants.STORAGE_CONFIG.getInt("MySQL.maximumPoolSize");
        if (maximumPoolSize > 0) {
            hikariConfig.setMaximumPoolSize(maximumPoolSize);
        }
        if ((minimumIdle = BaseConstants.STORAGE_CONFIG.getInt("MySQL.minimumIdle")) > 0) {
            hikariConfig.setMinimumIdle(minimumIdle);
        }
        if ((connectionTimeout = BaseConstants.STORAGE_CONFIG.getInt("MySQL.connectionTimeout")) > 0) {
            hikariConfig.setConnectionTimeout(connectionTimeout);
        }
    }
}

