/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.reward.listener;

import cn.handyplus.reward.enter.ActivationCodeEnter;
import cn.handyplus.reward.enter.ActivationCodePlayerEnter;
import cn.handyplus.reward.event.ActivationCodeUseEvent;
import cn.handyplus.reward.lib.annotation.HandyListener;
import cn.handyplus.reward.lib.core.StrUtil;
import cn.handyplus.reward.lib.util.BaseUtil;
import cn.handyplus.reward.lib.util.MessageUtil;
import cn.handyplus.reward.reward.RewardStrategy;
import cn.handyplus.reward.service.ActivationCodePlayerService;
import cn.handyplus.reward.service.ActivationCodeService;
import cn.handyplus.reward.service.PlayerRewardsService;
import java.util.Date;
import java.util.Optional;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

@HandyListener
public class ActivationCodeUseEventListener
implements Listener {
    @EventHandler
    public void onActivationCodeUse(ActivationCodeUseEvent event) {
        this.codeUser(event);
    }

    private synchronized void codeUser(ActivationCodeUseEvent event) {
        Player player = event.getPlayer();
        String cdk = event.getCdk();
        Optional<ActivationCodeEnter> cdkEnterOpt = ActivationCodeService.getInstance().selectByCdk(cdk);
        if (!cdkEnterOpt.isPresent()) {
            MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("noCdk"));
            return;
        }
        ActivationCodeEnter cdkEnter = cdkEnterOpt.get();
        if (cdkEnter.getExpirationTime() != null && cdkEnter.getExpirationTime().getTime() <= System.currentTimeMillis()) {
            MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("cdkExpiration"));
            return;
        }
        if (cdkEnter.getNumber().equals(cdkEnter.getUseNumber())) {
            MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("usedCdk"));
            return;
        }
        Optional<ActivationCodePlayerEnter> activationCodePlayerEnterOptional = ActivationCodePlayerService.getInstance().findByActivationCodeIdAndPlayerName(cdkEnter.getId(), player.getName());
        if (activationCodePlayerEnterOptional.isPresent()) {
            MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("usedCdk"));
            return;
        }
        if (StrUtil.isNotEmpty(cdkEnter.getPermission()) && !player.hasPermission(cdkEnter.getPermission())) {
            MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("noCdkPermission", "&a\u6ca1\u6709\u4f7f\u7528\u6743\u9650"));
            return;
        }
        cdkEnter.setUseNumber(cdkEnter.getUseNumber() + 1);
        ActivationCodeService.getInstance().updateUseNumberById(cdkEnter);
        ActivationCodePlayerEnter playerEnter = new ActivationCodePlayerEnter();
        playerEnter.setActivationCodeId(cdkEnter.getId());
        playerEnter.setPlayerName(player.getName());
        playerEnter.setPlayerUuid(player.getUniqueId().toString());
        playerEnter.setUseTime(new Date());
        ActivationCodePlayerService.getInstance().add(playerEnter);
        RewardStrategy.getInstance().reward(player, PlayerRewardsService.getInstance().selectByIds(StrUtil.strToIntList(cdkEnter.getRewards())));
        MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("useCdk"));
    }
}

