/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.reward.listener;

import cn.handyplus.reward.enter.GiftRewardsEnter;
import cn.handyplus.reward.lib.annotation.HandyListener;
import cn.handyplus.reward.lib.constants.VersionCheckEnum;
import cn.handyplus.reward.lib.core.StrUtil;
import cn.handyplus.reward.lib.util.BaseUtil;
import cn.handyplus.reward.lib.util.ItemStackUtil;
import cn.handyplus.reward.lib.util.MessageUtil;
import cn.handyplus.reward.reward.RewardStrategy;
import cn.handyplus.reward.service.GiftRewardsService;
import cn.handyplus.reward.service.PlayerRewardsService;
import cn.handyplus.reward.util.ConfigUtil;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

@HandyListener
public class GiftListener
implements Listener {
    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.isCancelled()) {
            return;
        }
        ItemStack item = event.getItem();
        Material material = Material.CAKE;
        String materialStr = ConfigUtil.MATERIAL_CONFIG.getString("gift.material");
        if (StrUtil.isNotEmpty(materialStr)) {
            material = ItemStackUtil.getMaterial(materialStr, Material.CAKE);
        }
        if (item == null || item.getAmount() > 1 || !material.equals((Object)item.getType()) || item.getItemMeta() == null || StrUtil.isEmpty(item.getItemMeta().getDisplayName())) {
            return;
        }
        if (VersionCheckEnum.getEnum().getVersionId() > VersionCheckEnum.V_1_8.getVersionId() && !EquipmentSlot.HAND.equals((Object)event.getHand())) {
            return;
        }
        Player player = event.getPlayer();
        ItemMeta itemMeta = item.getItemMeta();
        int giftId = itemMeta.getEnchantLevel(Enchantment.LURE);
        if (giftId == 0) {
            return;
        }
        Boolean rst = ItemStackUtil.removeItem(player, item, item.getAmount());
        if (!rst.booleanValue()) {
            return;
        }
        Optional<GiftRewardsEnter> giftRewardsEnterOptional = GiftRewardsService.getInstance().findById(giftId);
        if (!giftRewardsEnterOptional.isPresent()) {
            return;
        }
        GiftRewardsEnter giftRewardsEnter = giftRewardsEnterOptional.get();
        GiftRewardsService.getInstance().delById(giftId);
        RewardStrategy.getInstance().reward(player, PlayerRewardsService.getInstance().selectByIds(StrUtil.strToIntList(giftRewardsEnter.getRewards())));
        MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("useGift"));
    }
}

