/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.reward.listener.gui;

import cn.handyplus.reward.constants.GuiTypeEnum;
import cn.handyplus.reward.constants.PluginConstants;
import cn.handyplus.reward.enter.ActivationCodeEnter;
import cn.handyplus.reward.enter.GiftRewardsEnter;
import cn.handyplus.reward.inventory.CreateRewardsGui;
import cn.handyplus.reward.lib.core.CollUtil;
import cn.handyplus.reward.lib.core.StrUtil;
import cn.handyplus.reward.lib.inventory.HandyInventory;
import cn.handyplus.reward.lib.inventory.HandyInventoryUtil;
import cn.handyplus.reward.lib.inventory.IHandyClickEvent;
import cn.handyplus.reward.lib.util.BaseUtil;
import cn.handyplus.reward.lib.util.HandyConfigUtil;
import cn.handyplus.reward.lib.util.ItemStackUtil;
import cn.handyplus.reward.lib.util.MessageUtil;
import cn.handyplus.reward.service.ActivationCodeService;
import cn.handyplus.reward.service.GiftRewardsService;
import cn.handyplus.reward.util.ConfigUtil;
import cn.handyplus.reward.util.RewardsUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class CreateRewardsClickEvent
implements IHandyClickEvent {
    @Override
    public String guiType() {
        return GuiTypeEnum.CREATE_REWARDS.getType();
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void rawSlotClick(HandyInventory handyInventory, InventoryClickEvent event) {
        int rawSlot = event.getRawSlot();
        Integer pageNum = handyInventory.getPageNum();
        Integer pageCount = handyInventory.getPageCount();
        Player player = handyInventory.getPlayer();
        Map<Integer, Integer> map = handyInventory.getIntMap();
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.REWARD_CONFIG, "previousPage")) {
            if (pageNum > 1) {
                handyInventory.setPageNum(handyInventory.getPageNum() - 1);
                CreateRewardsGui.getInstance().setInventoryDate(handyInventory);
            }
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.REWARD_CONFIG, "nextPage")) {
            if (pageNum + 1 <= pageCount) {
                handyInventory.setPageNum(handyInventory.getPageNum() + 1);
                CreateRewardsGui.getInstance().setInventoryDate(handyInventory);
            }
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.REWARD_CONFIG, "step")) {
            handyInventory.syncClose();
            this.cdkDone(player);
            this.giftDone(player);
            return;
        }
        Integer rewardId = map.get(rawSlot);
        if (rewardId == null) {
            return;
        }
        this.cdkReward(player, rewardId);
        this.giftReward(player, rewardId);
        CreateRewardsGui.getInstance().setInventoryDate(handyInventory);
    }

    private void giftDone(Player player) {
        GiftRewardsEnter giftRewardsEnter = PluginConstants.GIFT_MAP.get(player.getUniqueId());
        if (giftRewardsEnter == null) {
            return;
        }
        int giftId = GiftRewardsService.getInstance().add(giftRewardsEnter);
        giftRewardsEnter.setId(giftId);
        ItemStack itemStack = RewardsUtil.createGiftItemStack(giftRewardsEnter);
        ItemStackUtil.addItem(player, itemStack);
        MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("giftSucceedMsg"));
        PluginConstants.GIFT_MAP.remove(player.getUniqueId());
    }

    private void cdkDone(Player player) {
        ActivationCodeEnter cdkEnter = PluginConstants.CKD_MAP.get(player.getUniqueId());
        if (cdkEnter == null) {
            return;
        }
        ArrayList<ActivationCodeEnter> cdkEnterList = new ArrayList<ActivationCodeEnter>();
        for (int i = 0; i < cdkEnter.getCreateNumber(); ++i) {
            ActivationCodeEnter cdk = new ActivationCodeEnter();
            cdk.setCdk(StrUtil.isEmpty(cdkEnter.getCdk()) ? UUID.randomUUID().toString() : cdkEnter.getCdk());
            cdk.setRewards(cdkEnter.getRewards());
            cdk.setUseNumber(0);
            cdk.setNumber(cdkEnter.getNumber());
            cdk.setCreateTime(new Date());
            cdk.setExpirationTime(cdkEnter.getExpirationTime());
            cdk.setPermission(cdkEnter.getPermission());
            cdkEnterList.add(cdk);
        }
        ActivationCodeService.getInstance().addAll(cdkEnterList);
        if (StrUtil.isEmpty(cdkEnter.getCdk())) {
            HandyConfigUtil.setPath(ConfigUtil.CDK_CONFIG, "cdk", cdkEnterList.stream().map(ActivationCodeEnter::getCdk).collect(Collectors.toList()), "cdk.yml");
            MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("finish"));
        } else {
            MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("createCdk").replace("${cdk}", cdkEnter.getCdk()));
        }
        PluginConstants.CKD_MAP.remove(player.getUniqueId());
    }

    private void cdkReward(Player player, Integer rewardId) {
        ActivationCodeEnter cdkEnter = PluginConstants.CKD_MAP.get(player.getUniqueId());
        if (cdkEnter == null) {
            return;
        }
        if (StrUtil.isEmpty(cdkEnter.getRewards())) {
            cdkEnter.setRewards(String.valueOf(rewardId));
        } else {
            List<Integer> rewardIds = StrUtil.strToIntList(cdkEnter.getRewards());
            if (rewardIds.contains(rewardId)) {
                rewardIds.remove(rewardId);
            } else {
                rewardIds.add(rewardId);
            }
            cdkEnter.setRewards(CollUtil.listToStr(rewardIds));
        }
    }

    private void giftReward(Player player, Integer rewardId) {
        GiftRewardsEnter giftRewardsEnter = PluginConstants.GIFT_MAP.get(player.getUniqueId());
        if (giftRewardsEnter == null) {
            return;
        }
        if (StrUtil.isEmpty(giftRewardsEnter.getRewards())) {
            giftRewardsEnter.setRewards(String.valueOf(rewardId));
        } else {
            List<Integer> rewardIds = StrUtil.strToIntList(giftRewardsEnter.getRewards());
            if (rewardIds.contains(rewardId)) {
                rewardIds.remove(rewardId);
            } else {
                rewardIds.add(rewardId);
            }
            giftRewardsEnter.setRewards(CollUtil.listToStr(rewardIds));
        }
    }
}

