/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.reward.listener.gui;

import cn.handyplus.reward.constants.GuiTypeEnum;
import cn.handyplus.reward.inventory.ViewRewardsGui;
import cn.handyplus.reward.lib.inventory.HandyInventory;
import cn.handyplus.reward.lib.inventory.HandyInventoryUtil;
import cn.handyplus.reward.lib.inventory.IHandyClickEvent;
import cn.handyplus.reward.service.PlayerRewardsService;
import cn.handyplus.reward.util.ConfigUtil;
import java.util.Map;
import org.bukkit.event.inventory.InventoryClickEvent;

public class ViewRewardsClickEvent
implements IHandyClickEvent {
    @Override
    public String guiType() {
        return GuiTypeEnum.VIEW_REWARDS.getType();
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void rawSlotClick(HandyInventory handyInventory, InventoryClickEvent event) {
        int rawSlot = event.getRawSlot();
        Integer pageNum = handyInventory.getPageNum();
        Integer pageCount = handyInventory.getPageCount();
        Map<Integer, Integer> map = handyInventory.getIntMap();
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.REWARD_CONFIG, "previousPage")) {
            if (pageNum > 1) {
                handyInventory.setPageNum(handyInventory.getPageNum() - 1);
                ViewRewardsGui.getInstance().setInventoryDate(handyInventory);
            }
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.REWARD_CONFIG, "nextPage")) {
            if (pageNum + 1 <= pageCount) {
                handyInventory.setPageNum(handyInventory.getPageNum() + 1);
                ViewRewardsGui.getInstance().setInventoryDate(handyInventory);
            }
            return;
        }
        Integer taskRewardId = map.get(event.getRawSlot());
        if (taskRewardId == null) {
            return;
        }
        PlayerRewardsService.getInstance().deleteById(taskRewardId);
        ViewRewardsGui.getInstance().setInventoryDate(handyInventory);
    }
}

