/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.reward.reward;

import cn.handyplus.reward.enter.PlayerRewardsEnter;
import cn.handyplus.reward.lib.core.CollUtil;
import cn.handyplus.reward.reward.IRewardService;
import cn.handyplus.reward.reward.impl.CommandServiceImpl;
import cn.handyplus.reward.reward.impl.ConsoleServiceImpl;
import cn.handyplus.reward.reward.impl.ItemStackRewardServiceImpl;
import cn.handyplus.reward.reward.impl.PlayerPointsRewardServiceImpl;
import cn.handyplus.reward.reward.impl.VaultRewardServiceImpl;
import java.util.List;
import org.bukkit.entity.Player;

public class RewardStrategy {
    private RewardStrategy() {
    }

    public static RewardStrategy getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public void reward(Player player, List<PlayerRewardsEnter> enterList) {
        if (CollUtil.isEmpty(enterList)) {
            return;
        }
        for (PlayerRewardsEnter enter : enterList) {
            IRewardService rewardService;
            if (enter.getAmount() == null || enter.getAmount() == 0) continue;
            switch (enter.getType()) {
                case "vault": {
                    rewardService = new VaultRewardServiceImpl();
                    break;
                }
                case "playerPoints": {
                    rewardService = new PlayerPointsRewardServiceImpl();
                    break;
                }
                case "itemStack": {
                    rewardService = new ItemStackRewardServiceImpl();
                    break;
                }
                case "command": {
                    rewardService = new CommandServiceImpl();
                    break;
                }
                case "console": {
                    rewardService = new ConsoleServiceImpl();
                    break;
                }
                default: {
                    return;
                }
            }
            rewardService.reward(player, enter);
        }
    }

    private static class SingletonHolder {
        private static final RewardStrategy INSTANCE = new RewardStrategy();

        private SingletonHolder() {
        }
    }
}

