/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.reward.service;

import cn.handyplus.reward.enter.ActivationCodePlayerEnter;
import cn.handyplus.reward.lib.db.Db;
import java.util.List;
import java.util.Optional;

public class ActivationCodePlayerService {
    private ActivationCodePlayerService() {
    }

    public static ActivationCodePlayerService getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public int add(ActivationCodePlayerEnter enter) {
        return Db.use(ActivationCodePlayerEnter.class).execution().insert(enter);
    }

    public List<ActivationCodePlayerEnter> findByActivationCodeId(Integer activationCodeId) {
        Db<ActivationCodePlayerEnter> db = Db.use(ActivationCodePlayerEnter.class);
        db.where().eq(ActivationCodePlayerEnter::getActivationCodeId, activationCodeId);
        return db.execution().list();
    }

    public Optional<ActivationCodePlayerEnter> findByActivationCodeIdAndPlayerName(Integer activationCodeId, String playerName) {
        Db<ActivationCodePlayerEnter> db = Db.use(ActivationCodePlayerEnter.class);
        db.where().eq(ActivationCodePlayerEnter::getActivationCodeId, activationCodeId).eq(ActivationCodePlayerEnter::getPlayerName, playerName);
        return db.execution().selectOne();
    }

    private static class SingletonHolder {
        private static final ActivationCodePlayerService INSTANCE = new ActivationCodePlayerService();

        private SingletonHolder() {
        }
    }
}

