/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.reward.service;

import cn.handyplus.reward.enter.ActivationCodeEnter;
import cn.handyplus.reward.lib.core.StrUtil;
import cn.handyplus.reward.lib.db.Db;
import cn.handyplus.reward.lib.db.UpdateCondition;
import java.util.Date;
import java.util.List;
import java.util.Optional;

public class ActivationCodeService {
    private ActivationCodeService() {
    }

    public static ActivationCodeService getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public int add(ActivationCodeEnter enter) {
        return Db.use(ActivationCodeEnter.class).execution().insert(enter);
    }

    public void addAll(List<ActivationCodeEnter> enterList) {
        for (ActivationCodeEnter enter : enterList) {
            this.add(enter);
        }
    }

    public boolean updateUseNumberById(ActivationCodeEnter enter) {
        Db<ActivationCodeEnter> db = Db.use(ActivationCodeEnter.class);
        UpdateCondition<ActivationCodeEnter> update = db.update();
        update.set(ActivationCodeEnter::getUseNumber, enter.getUseNumber());
        if (enter.getUseNumber().equals(enter.getNumber())) {
            update.set(ActivationCodeEnter::getAllUseTime, new Date());
        }
        return db.execution().updateById(enter.getId()) > 0;
    }

    public Optional<ActivationCodeEnter> selectByCdk(String cdk) {
        Db<ActivationCodeEnter> db = Db.use(ActivationCodeEnter.class);
        db.where().eq(StrUtil.isNotEmpty(cdk), ActivationCodeEnter::getCdk, cdk);
        return db.execution().selectOne();
    }

    private static class SingletonHolder {
        private static final ActivationCodeService INSTANCE = new ActivationCodeService();

        private SingletonHolder() {
        }
    }
}

