/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.reward.service;

import cn.handyplus.reward.enter.GiftRewardsEnter;
import cn.handyplus.reward.lib.db.Db;
import java.util.Optional;

public class GiftRewardsService {
    private GiftRewardsService() {
    }

    public static GiftRewardsService getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public int add(GiftRewardsEnter enter) {
        int maxId = this.findMaxId();
        enter.setId(maxId);
        return Db.use(GiftRewardsEnter.class).execution().insert(enter);
    }

    public int findMaxId() {
        Db<GiftRewardsEnter> db = Db.use(GiftRewardsEnter.class);
        db.where().orderByDesc(GiftRewardsEnter::getId).limit(1, 1);
        Optional<GiftRewardsEnter> giftRewardsEnter = db.execution().selectOne();
        return giftRewardsEnter.map(rewardsEnter -> rewardsEnter.getId() + 1).orElse(1);
    }

    public Optional<GiftRewardsEnter> findById(Integer id) {
        return Db.use(GiftRewardsEnter.class).execution().selectById(id);
    }

    public void delById(Integer id) {
        Db.use(GiftRewardsEnter.class).execution().deleteById(id);
    }

    private static class SingletonHolder {
        private static final GiftRewardsService INSTANCE = new GiftRewardsService();

        private SingletonHolder() {
        }
    }
}

