/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.reward.service;

import cn.handyplus.reward.enter.PlayerRewardsEnter;
import cn.handyplus.reward.lib.core.StrUtil;
import cn.handyplus.reward.lib.db.Db;
import cn.handyplus.reward.lib.db.Page;
import java.util.List;
import java.util.Optional;

public class PlayerRewardsService {
    private PlayerRewardsService() {
    }

    public static PlayerRewardsService getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public boolean add(PlayerRewardsEnter enter) {
        Db<PlayerRewardsEnter> db = Db.use(PlayerRewardsEnter.class);
        return db.execution().insert(enter) > 0;
    }

    public boolean edit(PlayerRewardsEnter enter) {
        Db<PlayerRewardsEnter> db = Db.use(PlayerRewardsEnter.class);
        db.update().set(PlayerRewardsEnter::getType, enter.getType()).set(PlayerRewardsEnter::getAmount, enter.getAmount()).set(PlayerRewardsEnter::getItemStack, enter.getItemStack()).set(PlayerRewardsEnter::getDescription, enter.getDescription());
        return db.execution().updateById(enter.getId()) > 0;
    }

    public Page<PlayerRewardsEnter> selectPageByType(String type, Integer pageNum, int pageSize) {
        Db<PlayerRewardsEnter> db = Db.use(PlayerRewardsEnter.class);
        db.where().eq(StrUtil.isNotEmpty(type), PlayerRewardsEnter::getType, type).limit(pageNum, pageSize);
        return db.execution().page();
    }

    public List<PlayerRewardsEnter> selectByIds(List<Integer> ids) {
        return Db.use(PlayerRewardsEnter.class).execution().selectBatchIds(ids);
    }

    public Optional<PlayerRewardsEnter> selectById(Integer id) {
        return Db.use(PlayerRewardsEnter.class).execution().selectById(id);
    }

    public void deleteById(Integer id) {
        Db.use(PlayerRewardsEnter.class).execution().deleteById(id);
    }

    private static class SingletonHolder {
        private static final PlayerRewardsService INSTANCE = new PlayerRewardsService();

        private SingletonHolder() {
        }
    }
}

