/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.reward.util;

import cn.handyplus.reward.constants.RewardType;
import cn.handyplus.reward.enter.GiftRewardsEnter;
import cn.handyplus.reward.enter.PlayerRewardsEnter;
import cn.handyplus.reward.lib.constants.BaseConstants;
import cn.handyplus.reward.lib.core.CollUtil;
import cn.handyplus.reward.lib.core.StrUtil;
import cn.handyplus.reward.lib.util.BaseUtil;
import cn.handyplus.reward.lib.util.ItemMetaUtil;
import cn.handyplus.reward.lib.util.ItemStackUtil;
import cn.handyplus.reward.service.PlayerRewardsService;
import cn.handyplus.reward.util.ConfigUtil;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class RewardsUtil {
    public static ItemStack createGiftItemStack(GiftRewardsEnter giftRewardsEnter) {
        String material = ConfigUtil.MATERIAL_CONFIG.getString("gift.material", Material.CAKE.name());
        int customModelDataId = ConfigUtil.MATERIAL_CONFIG.getInt("gift.custom-model-data");
        List lores = BaseConstants.LANG_CONFIG.getStringList("gift.lore");
        ArrayList<String> loreList = new ArrayList<String>();
        for (String lore : lores) {
            if (lore.contains("rewards")) {
                loreList.addAll(RewardsUtil.getReplaceLore(lore, giftRewardsEnter, "rewards"));
                continue;
            }
            if (lore.contains("button")) {
                loreList.addAll(RewardsUtil.getReplaceLore(lore, giftRewardsEnter, "button"));
                continue;
            }
            loreList.add(lore);
        }
        ItemStack itemStack = ItemStackUtil.getItemStack(material, giftRewardsEnter.getGiftName(), loreList, true, customModelDataId);
        ItemMeta itemMeta = ItemStackUtil.getItemMeta(itemStack);
        itemMeta.addEnchant(Enchantment.LURE, giftRewardsEnter.getId().intValue(), true);
        ItemMetaUtil.hideEnchant(itemMeta);
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    private static List<String> getReplaceLore(String lore, GiftRewardsEnter giftRewardsEnter, String type) {
        ArrayList<String> loreList = new ArrayList<String>();
        if ("rewards".equals(type)) {
            List<PlayerRewardsEnter> playerRewardsEnters = PlayerRewardsService.getInstance().selectByIds(StrUtil.strToIntList(giftRewardsEnter.getRewards()));
            if (CollUtil.isEmpty(playerRewardsEnters)) {
                String newLore = lore.replace("${rewards}", BaseUtil.getLangMsg("noReward"));
                loreList.add(newLore);
                return loreList;
            }
            for (PlayerRewardsEnter enter : playerRewardsEnters) {
                String typeName = RewardType.getTypeName(enter.getType());
                String displayName = "";
                if ("itemStack".equals(enter.getType())) {
                    ItemStack itemStack = ItemStackUtil.itemStackDeserialize(enter.getItemStack());
                    if (itemStack.getItemMeta() == null) continue;
                    displayName = BaseUtil.getDisplayName(itemStack);
                }
                if ("command".equals(enter.getType()) || "console".equals(enter.getType())) {
                    if (StrUtil.isEmpty(enter.getDescription())) {
                        loreList.add(lore.replace("${rewards}", typeName != null ? typeName : ""));
                        continue;
                    }
                    loreList.add(lore.replace("${rewards}", enter.getDescription()));
                    continue;
                }
                String newLore = lore.replace("${rewards}", typeName + " " + enter.getAmount() + " " + displayName);
                loreList.add(StrUtil.isEmpty(enter.getDescription()) ? newLore : enter.getDescription());
            }
        }
        if ("button".equals(type)) {
            String newLore = lore.replace("${button}", BaseUtil.getLangMsg("gift.finish"));
            loreList.add(newLore);
        }
        return loreList;
    }
}

