{
  onStart(pokemon) {
    this.add("-ability", pokemon, "Primal Resonance");
    this.add("-message", `${pokemon.name}'s primal resonance echoes through the field!`);
  },
  onBasePowerPriority: 8,
  onBasePower(basePower, attacker, defender, move) {
    if (move.type === 'Dragon') return this.chainModify(1.2);
  },
  onHit(target, source, move) {
    if (
      source !== target &&
      move.type === 'Dragon' &&
      move.category !== 'Status'
    ) {
      if (this.random(10) < 3) {
        const statuses = ['par','brn','frz'];
        const status = this.sample(statuses);
        target.trySetStatus(status, source);
      }
    }
  },
  onDamagingHit(damage, target, source, move) {
    if (move.category !== 'Status' && this.random(10) < 3) {
      this.boost(
        { atk: 1, def: 1, spa: 1, spd: 1, spe: 1 },
        target,
        target,
        null,
        true
      );
      this.add("-message", `${target.name}'s resonance empowers it!`);
    }
  },
  flags: { breakable: 1 },
  name: "Primal Resonance",
  rating: 4,
  num: -802
}