{
  onStart(pokemon) {
    this.add("-ability", pokemon, "Prime Fusion");
    this.add("-message", `The primal energies converge upon ${pokemon.name}!`);
    this.boost({ atk: 1, def: 1, spa: 1, spd: 1, spe: 1 }, pokemon);
  },
  onModifyDamage(damage, source, target, move) {
    if (move.type === 'Dragon') {
      return this.chainModify(1.3);
    }
  },
  onTryHit(target, source, move) {
    if (['Fire', 'Electric', 'Ice'].includes(move.type)) {
      this.add('-immune', target, '[from] ability: Prime Fusion');
      return null;
    }
  },
  onResidual(pokemon) {
    this.heal(pokemon.maxhp / 16);
  },
  flags: { breakable: 1 },
  name: "Prime Fusion",
  rating: 5,
  num: -800
}