{
  num: 9025,
  accuracy: 70,
  basePower: 0,
  category: "Special",
  name: "Wuji Annihilation",
  pp: 1,
  priority: 0,
  flags: { protect: 1, failcopycat: 1, failmimic: 1 },
  target: "allAdjacentFoes",
  type: "Dragon",
  ohko: true,

  onTryHit(target, source, move) {
    this.add('-message', `${source.name} calls upon the void of Wuji to unmake existence...`);
  },

  onHit(target, source, move) {
    this.add('-message', "The primal void devours everything!");
    for (const foe of source.side.foe.pokemon) {
      if (foe && !foe.fainted) {
        this.faint(foe);
      }
    }
  },

  onMoveFail(target, source, move) {
    this.add('-message', `${source.name} is consumed by the backlash of infinite chaos!`);
    this.damage(source.maxhp / 2, source, source, move);
    this.boost({ atk: -2, def: -2, spa: -2, spd: -2, spe: -2 }, source);
  },

  shortDesc: "70% OHKO all foes. Miss = lose 50% HP & -2 all stats.",
  desc: "Annihilates all foes with the void of Wuji. If it fails, the user is heavily damaged and weakened.",
  contestType: "Cool"
}
