{
  onStart(pokemon) {
    this.add("-ability", pokemon, "Tao Reforged");
    this.add("-message", `${pokemon.name} radiates unified elemental power...`);
  },

  onBasePowerPriority: 21,
  onBasePower(basePower, attacker, defender, move) {
    if (!move || !move.type) return;

    if (['Fire', 'Electric', 'Ice'].includes(move.type)) {
      return this.chainModify(1.2);
    }
  },

  onDamagingHit(damage, target, source, move) {
    if (!move || !move.type) return;

    if (move.type === 'Fire') {
      this.add("-message", `${target.name} absorbs the flames and sharpens its mind!`);
      this.boost({ spa: 1 }, target);
    } else if (move.type === 'Electric') {
      this.add("-message", `${target.name} channels the current and surges with speed!`);
      this.boost({ spe: 1 }, target);
    } else if (move.type === 'Ice') {
      this.add("-message", `${target.name} endures the frost and hardens its defense!`);
      this.boost({ def: 1 }, target);
    }
  },

  flags: { breakable: 1 },
  name: "Tao Reforged",
  rating: 6,
  num: -980
}
