{
  onStart(pokemon) {
    this.add("-ability", pokemon, "Unified Might");
    this.add("-message", `${pokemon.name}'s original essence awakens!`);
    this.effectState.source = pokemon;
  },
  onAfterMove(source, target, move) {
    if (
      source !== this.effectState.source ||
      move.category === 'Status' ||
      move.type !== 'Dragon'
    ) return;
    this.add("-message", `${source.name}'s essence surges!`);
    const stats = ['atk','def','spa','spd','spe'];
    const boost = this.sample(stats);
    this.boost({ [boost]: 1 }, source);
  },
  flags: { breakable: 1 },
  name: "Unified Might",
  rating: 4,
  num: -801
}