{
  onStart(pokemon) {
    this.add("-ability", pokemon, "Wuji Balance");
    this.add("-message", `${pokemon.name} embodies Wuji Balance!`);
    this.field.clearWeather();
    this.field.clearTerrain();
  },
  onModifyDamage(damage, source, target, move) {
    if (['Dragon','Fire','Electric','Ice'].includes(move.type)) {
      return this.chainModify(1.3);
    }
  },
  onAfterMove(pokemon, target, move) {
    if (move.category === 'Status') return;
    const mapping = { Dragon: 'atk', Fire: 'spa', Electric: 'spe', Ice: 'def' };
    const stat = mapping[move.type];
    if (stat) {
      this.boost({ [stat]: 1 }, pokemon);
      this.add("-message", `${pokemon.name}'s ${move.type} essence strengthens its ${stat}!`);
    }
  },
  flags: { breakable: 1 },
  name: "Wuji Balance",
  rating: 4,
  num: -905
}