package com.hidoni.transmog.mixin;

import com.hidoni.transmog.TransmogUtils;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(ItemModelResolver.class)
public class ItemModelResolverMixin {
    @ModifyVariable(method = "updateForTopItem", at=@At("HEAD"), argsOnly = true)
    private ItemStack transmog$updateForTopItem(ItemStack stack) {
        return TransmogUtils.getAppearanceStackOrOriginal(stack);
    }
}
