/*
 * Decompiled with CFR 0.152.
 */
package me.bloodred;

import me.bloodred.config.FreelookConfig;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_5498;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class FreelookManager {
    private static FreelookManager instance;
    private boolean freelookEnabled = false;
    private boolean toggleMode = false;
    private class_5498 originalPerspective = null;
    private float cameraYaw = 0.0f;
    private float cameraPitch = 0.0f;
    private boolean firstTime = true;
    private FreelookConfig config = FreelookConfig.load();

    private FreelookManager() {
    }

    public static FreelookManager getInstance() {
        if (instance == null) {
            instance = new FreelookManager();
        }
        return instance;
    }

    public void toggleFreelook() {
        this.toggleFreelook(true);
    }

    public void enableFreelookHold() {
        if (!this.freelookEnabled) {
            this.toggleFreelook(false);
        }
    }

    public void disableFreelookHold() {
        if (this.freelookEnabled && !this.toggleMode) {
            this.disableFreelook();
        }
    }

    private void toggleFreelook(boolean isToggleMode) {
        if (!this.freelookEnabled) {
            this.startFreelook(isToggleMode);
        } else {
            this.disableFreelook();
        }
    }

    private void startFreelook(boolean isToggleMode) {
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        if (player == null) {
            return;
        }
        this.freelookEnabled = true;
        this.toggleMode = isToggleMode;
        this.firstTime = true;
        this.originalPerspective = mc.field_1690.method_31044();
        if (this.config.isAutoThirdPerson() && this.originalPerspective == class_5498.field_26664) {
            mc.field_1690.method_31043(class_5498.field_26665);
        }
    }

    private void disableFreelook() {
        this.freelookEnabled = false;
        this.toggleMode = false;
        this.firstTime = true;
        class_310 mc = class_310.method_1551();
        if (this.originalPerspective != null) {
            mc.field_1690.method_31043(this.originalPerspective);
        }
        this.originalPerspective = null;
    }

    public void updateFreelookRotation(double deltaX, double deltaY) {
        if (!this.freelookEnabled) {
            return;
        }
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        if (player == null) {
            return;
        }
        if (this.firstTime) {
            this.cameraYaw = player.method_36454();
            this.cameraPitch = player.method_36455();
            this.firstTime = false;
        }
        float mouseSensitivity = ((Double)mc.field_1690.method_42495().method_41753()).floatValue() * this.config.getSensitivity();
        float pitchDelta = (float)(deltaY * 0.15 * (double)mouseSensitivity);
        float yawDelta = (float)(deltaX * 0.15 * (double)mouseSensitivity);
        if (this.config.isInvertY()) {
            pitchDelta = -pitchDelta;
        }
        this.cameraPitch = Math.max(-90.0f, Math.min(90.0f, this.cameraPitch + pitchDelta));
        this.cameraYaw += yawDelta;
    }

    public boolean isFreelookEnabled() {
        return this.freelookEnabled;
    }

    public float getCameraYaw() {
        return this.cameraYaw;
    }

    public float getCameraPitch() {
        return this.cameraPitch;
    }

    public boolean isFirstTime() {
        return this.firstTime;
    }

    public void setFirstTime(boolean firstTime) {
        this.firstTime = firstTime;
    }

    public FreelookConfig getConfig() {
        return this.config;
    }
}

