/*
 * Decompiled with CFR 0.152.
 */
package me.bloodred.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

@Environment(value=EnvType.CLIENT)
public class FreelookConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("freelookplusplus.json");
    public float sensitivity = 1.0f;
    public boolean invertY = false;
    public boolean smoothTransition = true;
    public boolean autoThirdPerson = true;

    public static FreelookConfig load() {
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try {
                String json = Files.readString(CONFIG_PATH);
                return (FreelookConfig)GSON.fromJson(json, FreelookConfig.class);
            }
            catch (IOException e) {
                System.err.println("Failed to load Freelook++ config: " + e.getMessage());
            }
        }
        FreelookConfig config = new FreelookConfig();
        config.save();
        return config;
    }

    public void save() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            String json = GSON.toJson((Object)this);
            Files.writeString(CONFIG_PATH, (CharSequence)json, new OpenOption[0]);
        }
        catch (IOException e) {
            System.err.println("Failed to save Freelook++ config: " + e.getMessage());
        }
    }

    public float getSensitivity() {
        return Math.max(0.1f, Math.min(3.0f, this.sensitivity));
    }

    public void setSensitivity(float sensitivity) {
        this.sensitivity = Math.max(0.1f, Math.min(3.0f, sensitivity));
    }

    public boolean isInvertY() {
        return this.invertY;
    }

    public void setInvertY(boolean invertY) {
        this.invertY = invertY;
    }

    public boolean isSmoothTransition() {
        return this.smoothTransition;
    }

    public void setSmoothTransition(boolean smoothTransition) {
        this.smoothTransition = smoothTransition;
    }

    public boolean isAutoThirdPerson() {
        return this.autoThirdPerson;
    }

    public void setAutoThirdPerson(boolean autoThirdPerson) {
        this.autoThirdPerson = autoThirdPerson;
    }
}

