/*
 * Decompiled with CFR 0.152.
 */
package top.toobee.optimization.cache;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import net.minecraft.class_1937;

public interface AttachedCache<T> {
    public class_1937 getWorld();

    public AtomicInteger getReferencedCounter();

    public Lock getLock();

    public long getLastUpdateTick();

    public void setLastUpdateTick(long var1);

    public boolean getHasUpdatedThisTick();

    public void setHasUpdatedThisTick(boolean var1);

    public boolean failCondition(T var1);

    public void truncate();

    default public void tick() {
        long time = this.getWorld().method_8510();
        if (this.getLastUpdateTick() != time) {
            if (this.getHasUpdatedThisTick()) {
                this.setHasUpdatedThisTick(false);
                this.setLastUpdateTick(time);
            } else if (time - this.getLastUpdateTick() >> 8 != 0L) {
                this.truncate();
            }
            if (this.getReferencedCounter().get() >> 4 == 0) {
                this.truncate();
            }
        }
    }
}

