/*
 * Decompiled with CFR 0.152.
 */
package top.toobee.optimization.cache;

import java.util.List;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_3218;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_4760;
import net.minecraft.class_4836;
import net.minecraft.class_4838;
import net.minecraft.class_5418;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import top.toobee.optimization.accessor.MobEntityAccessor;
import top.toobee.optimization.cache.Caches;
import top.toobee.optimization.cache.StackingMobCache;
import top.toobee.optimization.intermediary.DataTrackerIntermediary;
import top.toobee.optimization.util.ListExt;

public final class PiglinCache
extends StackingMobCache<class_4836> {
    public static final Caches<class_4836, PiglinCache> CACHES = new Caches<class_4836, PiglinCache>(class_4836.class, PiglinCache::new);
    public static final int MOB_FLAGS_ID = MobEntityAccessor.getMobFlags().comp_2327();
    private MemoryCache memoryCache = MemoryCache.DEFAULT;
    private boolean changeAttacking = false;
    @Nullable
    private List<class_1542> nearestItems = null;
    public List<class_1542> canPickUpItems = List.of();

    public PiglinCache(class_1937 world, class_2338 pos) {
        super(world, pos);
    }

    @Override
    public void newSense(class_3218 serverWorld, class_4836 entity) {
        class_4095 brain = entity.method_18868();
        MemoryCache c = this.memoryCache;
        brain.method_18879(class_4140.field_22474, c.NEAREST_REPELLENT);
        brain.method_18879(class_4140.field_25360, c.NEAREST_VISIBLE_NEMESIS);
        brain.method_18879(class_4140.field_22339, c.NEAREST_VISIBLE_HUNTABLE_HOGLIN);
        brain.method_18879(class_4140.field_22340, c.NEAREST_VISIBLE_BABY_HOGLIN);
        brain.method_18879(class_4140.field_22346, c.NEAREST_VISIBLE_ZOMBIFIED);
        brain.method_18879(class_4140.field_22342, c.NEAREST_TARGETABLE_PLAYER_NOT_WEARING_GOLD);
        brain.method_18879(class_4140.field_22349, c.NEAREST_PLAYER_HOLDING_WANTED_ITEM);
        brain.method_18879(class_4140.field_25755, c.NEARBY_ADULT_PIGLINS);
        brain.method_18879(class_4140.field_22343, c.NEAREST_VISIBLE_ADULT_PIGLINS);
        brain.method_18879(class_4140.field_22347, c.VISIBLE_ADULT_PIGLIN_COUNT);
        brain.method_18879(class_4140.field_22348, c.VISIBLE_ADULT_HOGLIN_COUNT);
    }

    public void reset(class_4095<class_4836> brain) {
        this.memoryCache = new MemoryCache(brain.method_46873(class_4140.field_22474), brain.method_46873(class_4140.field_25360), brain.method_46873(class_4140.field_22339), brain.method_46873(class_4140.field_22340), brain.method_46873(class_4140.field_22346), brain.method_46873(class_4140.field_22342), brain.method_46873(class_4140.field_22349), brain.method_46873(class_4140.field_25755), brain.method_46873(class_4140.field_22343), brain.method_46873(class_4140.field_22347), brain.method_46873(class_4140.field_22348));
    }

    @Override
    public void truncate() {
        PiglinCache.CACHES.all.remove(Pair.of((Object)this.world, (Object)this.pos));
    }

    @Override
    public boolean failCondition(class_4836 t) {
        return super.failCondition(t) || t.method_6109();
    }

    @Nullable
    public List<class_1542> getNearestItems() {
        return this.nearestItems;
    }

    public void setNearestItems(@Nullable List<class_1542> nearestItems) {
        this.nearestItems = nearestItems == null ? null : ListExt.prioritize(nearestItems, it -> it.method_73189().method_24802((class_2374)this.pos.method_46558(), 32.0), it -> it.method_6983().method_31574(class_4838.field_23826) && it.method_24515().equals((Object)this.pos));
    }

    public void redirectAttacking(class_4836 instance, boolean attacking) {
        if (this.getHasUpdatedThisTick()) {
            if (this.changeAttacking) {
                DataTrackerIntermediary t = (DataTrackerIntermediary)instance.method_5841();
                byte b = t.toobee$getMobFlags();
                t.toobee$setMobFlags((byte)(attacking ? b | 4 : b & 0xFFFFFFFB));
            }
        } else {
            this.changeAttacking = instance.method_6510() != attacking;
            instance.method_19540(attacking);
        }
    }

    public Optional<class_1542> getNearestItem(class_3218 serverWorld, class_4836 piglin) {
        List<class_1542> items = this.nearestItems;
        if (items == null) {
            return Optional.empty();
        }
        for (class_1542 item : items) {
            if (!piglin.method_20820(serverWorld, item.method_6983()) || !piglin.method_6057((class_1297)item)) continue;
            return Optional.of(item);
        }
        return Optional.empty();
    }

    @Override
    public void tick() {
        super.tick();
        this.nearestItems = null;
    }

    private record MemoryCache(Optional<class_2338> NEAREST_REPELLENT, Optional<class_1308> NEAREST_VISIBLE_NEMESIS, Optional<class_4760> NEAREST_VISIBLE_HUNTABLE_HOGLIN, Optional<class_4760> NEAREST_VISIBLE_BABY_HOGLIN, Optional<class_1309> NEAREST_VISIBLE_ZOMBIFIED, Optional<class_1657> NEAREST_TARGETABLE_PLAYER_NOT_WEARING_GOLD, Optional<class_1657> NEAREST_PLAYER_HOLDING_WANTED_ITEM, Optional<List<class_5418>> NEARBY_ADULT_PIGLINS, Optional<List<class_5418>> NEAREST_VISIBLE_ADULT_PIGLINS, Optional<Integer> VISIBLE_ADULT_PIGLIN_COUNT, Optional<Integer> VISIBLE_ADULT_HOGLIN_COUNT) {
        static final MemoryCache DEFAULT = new MemoryCache(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }
}

