/*
 * Decompiled with CFR 0.152.
 */
package top.toobee.optimization.cache;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_6670;
import org.jetbrains.annotations.Nullable;
import top.toobee.optimization.cache.AttachedCache;

public abstract class StackingMobCache<T extends class_1308>
implements AttachedCache<T> {
    private final ReentrantLock lock = new ReentrantLock();
    private final AtomicInteger referencedCounter = new AtomicInteger(0);
    private List<class_1309> trackers = Collections.emptyList();
    @Nullable
    private class_1309 nearestTarget = null;
    protected final class_1937 world;
    public final class_2338 pos;
    @Nullable
    public Boolean shouldRunMoveToTargetTask = null;
    public Optional<class_2338> supportingBlockPos = Optional.empty();
    public Optional<class_1309> lookAtMobTaskEntity = Optional.empty();
    private long lastUpdateTick = 0L;
    private volatile boolean recheckUpdate = false;
    private boolean hasUpdatedThisTick = false;

    public StackingMobCache(class_1937 world, class_2338 pos) {
        this.world = world;
        this.pos = pos;
    }

    @Override
    public final class_1937 getWorld() {
        return this.world;
    }

    @Override
    public final Lock getLock() {
        return this.lock;
    }

    @Override
    public final AtomicInteger getReferencedCounter() {
        return this.referencedCounter;
    }

    @Override
    public final long getLastUpdateTick() {
        return this.lastUpdateTick;
    }

    @Override
    public final boolean getHasUpdatedThisTick() {
        return this.hasUpdatedThisTick;
    }

    @Nullable
    public final class_1309 getNearestTarget() {
        return this.nearestTarget;
    }

    @Override
    public final void setLastUpdateTick(long l) {
        this.lastUpdateTick = l;
    }

    @Override
    public final void setHasUpdatedThisTick(boolean b) {
        if (b != this.hasUpdatedThisTick) {
            this.hasUpdatedThisTick = b;
            this.recheckUpdate = b;
        }
    }

    public final void setTrackers(List<class_1309> trackers) {
        if (!this.recheckUpdate && this.lock.tryLock()) {
            try {
                this.trackers = trackers;
                this.recheckUpdate = true;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public final void setNearestTarget(@Nullable class_1309 e) {
        this.lock.lock();
        try {
            this.nearestTarget = e;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean failCondition(T t) {
        return !t.method_24515().equals((Object)this.pos) || t.method_73183() != this.world || !t.method_5805();
    }

    @Override
    public void tick() {
        AttachedCache.super.tick();
        this.shouldRunMoveToTargetTask = null;
        this.supportingBlockPos = Optional.empty();
        this.lookAtMobTaskEntity = Optional.empty();
        this.nearestTarget = null;
        this.recheckUpdate = false;
    }

    public final void senseNearestLivingEntities(class_3218 serverWorld, T t) {
        class_4095 brain = t.method_18868();
        brain.method_18878(class_4140.field_18441, this.trackers);
        brain.method_18878(class_4140.field_18442, (Object)new class_6670(serverWorld, t, this.trackers));
    }

    public abstract void newSense(class_3218 var1, T var2);
}

