/*
 * Decompiled with CFR 0.152.
 */
package RASMI.rlogin.jda.jda.api.interactions.commands;

import RASMI.rlogin.jda.jda.api.JDA;
import RASMI.rlogin.jda.jda.api.entities.Guild;
import RASMI.rlogin.jda.jda.api.interactions.commands.Command;
import RASMI.rlogin.jda.jda.api.interactions.commands.privileges.IntegrationPrivilege;
import RASMI.rlogin.jda.jda.internal.utils.Checks;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PrivilegeConfig {
    private final Guild guild;
    private final Map<String, List<IntegrationPrivilege>> privileges;

    public PrivilegeConfig(@Nonnull Guild guild, @Nonnull Map<String, List<IntegrationPrivilege>> privileges) {
        this.guild = guild;
        this.privileges = Collections.unmodifiableMap(privileges);
    }

    @Nonnull
    public Guild getGuild() {
        return this.guild;
    }

    @Nonnull
    public JDA getJDA() {
        return this.guild.getJDA();
    }

    @Nullable
    public List<IntegrationPrivilege> getApplicationPrivileges() {
        return this.getCommandPrivileges(this.getJDA().getSelfUser().getApplicationId());
    }

    @Nullable
    public List<IntegrationPrivilege> getCommandPrivileges(@Nonnull String id) {
        Checks.notNull(id, "Id");
        return this.privileges.get(id);
    }

    @Nullable
    public List<IntegrationPrivilege> getCommandPrivileges(@Nonnull Command command) {
        Checks.notNull(command, "Command");
        return this.privileges.get(command.getId());
    }

    @Nonnull
    public Map<String, List<IntegrationPrivilege>> getAsMap() {
        return this.privileges;
    }
}

