/*
 * Decompiled with CFR 0.152.
 */
package RASMI.rlogin.jda.jda.internal.entities.channel.concrete;

import RASMI.rlogin.jda.jda.api.Permission;
import RASMI.rlogin.jda.jda.api.entities.Guild;
import RASMI.rlogin.jda.jda.api.entities.Member;
import RASMI.rlogin.jda.jda.api.entities.PermissionOverride;
import RASMI.rlogin.jda.jda.api.entities.channel.ChannelType;
import RASMI.rlogin.jda.jda.api.entities.channel.concrete.Category;
import RASMI.rlogin.jda.jda.api.entities.channel.concrete.TextChannel;
import RASMI.rlogin.jda.jda.api.entities.channel.middleman.GuildChannel;
import RASMI.rlogin.jda.jda.api.entities.channel.unions.DefaultGuildChannelUnion;
import RASMI.rlogin.jda.jda.api.managers.channel.concrete.TextChannelManager;
import RASMI.rlogin.jda.jda.api.requests.restaction.ChannelAction;
import RASMI.rlogin.jda.jda.internal.entities.GuildImpl;
import RASMI.rlogin.jda.jda.internal.entities.channel.middleman.AbstractStandardGuildMessageChannelImpl;
import RASMI.rlogin.jda.jda.internal.entities.channel.mixin.attribute.ISlowmodeChannelMixin;
import RASMI.rlogin.jda.jda.internal.managers.channel.concrete.TextChannelManagerImpl;
import RASMI.rlogin.jda.jda.internal.utils.Checks;
import RASMI.rlogin.jda.jda.internal.utils.Helpers;
import java.util.List;
import javax.annotation.Nonnull;

public class TextChannelImpl
extends AbstractStandardGuildMessageChannelImpl<TextChannelImpl>
implements TextChannel,
DefaultGuildChannelUnion,
ISlowmodeChannelMixin<TextChannelImpl> {
    private int slowmode;

    public TextChannelImpl(long id, GuildImpl guild) {
        super(id, guild);
    }

    @Override
    @Nonnull
    public ChannelType getType() {
        return ChannelType.TEXT;
    }

    @Override
    @Nonnull
    public List<Member> getMembers() {
        return this.getGuild().getMembersView().stream().filter(m -> m.hasPermission((GuildChannel)this, Permission.VIEW_CHANNEL)).collect(Helpers.toUnmodifiableList());
    }

    @Override
    public int getSlowmode() {
        return this.slowmode;
    }

    @Override
    @Nonnull
    public ChannelAction<TextChannel> createCopy(@Nonnull Guild guild) {
        Checks.notNull(guild, "Guild");
        ChannelAction<TextChannel> action = guild.createTextChannel(this.name).setNSFW(this.nsfw).setTopic(this.topic).setSlowmode(this.slowmode);
        if (guild.equals(this.getGuild())) {
            Category parent = this.getParentCategory();
            if (parent != null) {
                action.setParent(parent);
            }
            for (PermissionOverride o : this.overrides.valueCollection()) {
                if (o.isMemberOverride()) {
                    action.addMemberPermissionOverride(o.getIdLong(), o.getAllowedRaw(), o.getDeniedRaw());
                    continue;
                }
                action.addRolePermissionOverride(o.getIdLong(), o.getAllowedRaw(), o.getDeniedRaw());
            }
        }
        return action;
    }

    @Override
    @Nonnull
    public TextChannelManager getManager() {
        return new TextChannelManagerImpl(this);
    }

    @Override
    public TextChannelImpl setSlowmode(int slowmode) {
        this.slowmode = slowmode;
        return this;
    }
}

