/*
 * Decompiled with CFR 0.152.
 */
package RASMI.rlogin.jda.jda.internal.handle;

import RASMI.rlogin.jda.jda.api.entities.channel.concrete.ThreadChannel;
import RASMI.rlogin.jda.jda.api.events.thread.ThreadRevealedEvent;
import RASMI.rlogin.jda.jda.api.utils.data.DataArray;
import RASMI.rlogin.jda.jda.api.utils.data.DataObject;
import RASMI.rlogin.jda.jda.internal.JDAImpl;
import RASMI.rlogin.jda.jda.internal.entities.EntityBuilder;
import RASMI.rlogin.jda.jda.internal.handle.SocketHandler;

public class ThreadListSyncHandler
extends SocketHandler {
    public ThreadListSyncHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(DataObject content) {
        long guildId = content.getLong("guild_id");
        if (this.api.getGuildSetupController().isLocked(guildId)) {
            return guildId;
        }
        EntityBuilder entityBuilder = this.api.getEntityBuilder();
        DataArray threadsArrayJson = content.getArray("threads");
        for (int i = 0; i < threadsArrayJson.length(); ++i) {
            DataObject threadJson = threadsArrayJson.getObject(i);
            try {
                ThreadChannel thread2 = entityBuilder.createThreadChannel(threadJson, guildId);
                this.api.handleEvent(new ThreadRevealedEvent(this.api, this.responseNumber, thread2));
                continue;
            }
            catch (IllegalArgumentException ex) {
                if (!"MISSING_CHANNEL".equals(ex.getMessage())) {
                    throw ex;
                }
                EntityBuilder.LOG.debug("Discarding thread on sync because of missing parent channel cache. JSON: {}", (Object)threadJson);
            }
        }
        return null;
    }
}

