/*
 * Decompiled with CFR 0.152.
 */
package RASMI.rlogin;

import RASMI.rlogin.gson.JsonArray;
import RASMI.rlogin.gson.JsonElement;
import RASMI.rlogin.gson.JsonObject;
import RASMI.rlogin.gson.JsonParser;
import RASMI.rlogin.jda.jda.api.JDA;
import RASMI.rlogin.jda.jda.api.JDABuilder;
import RASMI.rlogin.jda.jda.api.events.interaction.component.ButtonInteractionEvent;
import RASMI.rlogin.jda.jda.api.events.message.MessageReceivedEvent;
import RASMI.rlogin.jda.jda.api.hooks.ListenerAdapter;
import RASMI.rlogin.jda.jda.api.interactions.components.buttons.Button;
import RASMI.rlogin.jda.jda.api.requests.restaction.MessageCreateAction;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.time.Duration;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Rlogin
extends JavaPlugin
implements Listener {
    private static final String PERMISSION_ADMIN = "rlogin.admin";
    private static final String PASSWORDS_PATH = "passwords";
    private static final String IPS_PATH = "ips";
    private static final String TWO_FA_PATH = "2fa";
    private static final Set<String> HIDDEN_COMMANDS = Set.of("login", "l", "register", "reg", "changepass", "add2fa", "remove2fa", "addtg2fa", "removetg2fa");
    private static final Set<String> ALLOWED_COMMANDS = Set.of("login", "l", "register", "reg", "changepass", "rlchangepass", "rlogin", "add2fa", "remove2fa", "addtg2fa", "removetg2fa");
    private final Map<String, Boolean> loggedInPlayers = new HashMap<String, Boolean>();
    private final Map<String, Integer> loginAttempts = new HashMap<String, Integer>();
    private final Map<String, String> pending2FACodes = new ConcurrentHashMap<String, String>();
    private final Map<String, String> pendingRemove2FACodes = new ConcurrentHashMap<String, String>();
    private final Map<String, String> pendingLogins = new ConcurrentHashMap<String, String>();
    private final Map<String, String> pendingTg2FACodes = new ConcurrentHashMap<String, String>();
    private final Map<String, String> pendingRemoveTg2FACodes = new ConcurrentHashMap<String, String>();
    private final Map<String, String> pendingTgLogins = new ConcurrentHashMap<String, String>();
    private final Map<String, Long> pendingTgButtons = new ConcurrentHashMap<String, Long>();
    private final File passwordsFile = new File(this.getDataFolder(), "passwords.yml");
    private final FileConfiguration passwordsConfig = YamlConfiguration.loadConfiguration((File)this.passwordsFile);
    private final File ipFile = new File(this.getDataFolder(), "ips.yml");
    private final FileConfiguration ipConfig = YamlConfiguration.loadConfiguration((File)this.ipFile);
    private final File twoFaFile = new File(this.getDataFolder(), "2fa.yml");
    private final FileConfiguration twoFaConfig = YamlConfiguration.loadConfiguration((File)this.twoFaFile);
    private final File tgTwoFaFile = new File(this.getDataFolder(), "tg2fa.yml");
    private final FileConfiguration tgTwoFaConfig = YamlConfiguration.loadConfiguration((File)this.tgTwoFaFile);
    private JDA jda;
    private String telegramBotToken;
    private long lastTelegramUpdate = 0L;
    private BukkitRunnable telegramPollingTask;
    private final HttpClient httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).build();

    public void onEnable() {
        this.saveDefaultConfig();
        this.setupDefaultMessages();
        this.initializeConfigFile(this.passwordsFile);
        this.initializeConfigFile(this.ipFile);
        this.initializeConfigFile(this.twoFaFile);
        this.initializeConfigFile(this.tgTwoFaFile);
        if (this.getConfig().getBoolean("discord.enabled", false)) {
            try {
                this.jda = JDABuilder.createDefault(this.getConfig().getString("discord.bot_token")).addEventListeners(new DiscordListener(this)).build();
                this.jda.awaitReady();
                this.getLogger().info("Discord-\u0431\u043e\u0442 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u043d.");
            }
            catch (Exception e) {
                this.getLogger().warning("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u0442\u044c Discord-\u0431\u043e\u0442\u0430: " + e.getMessage());
                this.jda = null;
            }
        } else {
            this.getLogger().info("Discord-\u0431\u043e\u0442 \u043e\u0442\u043a\u043b\u044e\u0447\u0451\u043d \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438.");
        }
        if (this.getConfig().getBoolean("telegram.enabled", false)) {
            this.telegramBotToken = this.getConfig().getString("telegram.bot_token");
            if (this.telegramBotToken != null && !this.telegramBotToken.isEmpty() && !this.telegramBotToken.equals("YOUR_TELEGRAM_BOT_TOKEN_HERE")) {
                this.startTelegramPolling();
                this.getLogger().info("Telegram-\u0431\u043e\u0442 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u043d.");
            } else {
                this.getLogger().warning("Telegram bot token \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d. Telegram 2FA \u0431\u0443\u0434\u0435\u0442 \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u0430.");
            }
        } else {
            this.getLogger().info("Telegram-\u0431\u043e\u0442 \u043e\u0442\u043a\u043b\u044e\u0447\u0451\u043d \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438.");
        }
        this.registerCommands("login", "register", "l", "reg", "changepass", "rlchangepass", "rlogin", "add2fa", "remove2fa", "addtg2fa", "removetg2fa");
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        new BukkitRunnable(){

            public void run() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (Rlogin.this.isLoggedIn(player)) continue;
                    String playerName = player.getName();
                    String message = Rlogin.this.getPasswords().containsKey(playerName) ? (Rlogin.this.is2FAEnabled(playerName) && Rlogin.this.pendingLogins.containsValue(playerName) ? Rlogin.this.getConfig().getString("messages.login_2fa_pending") : Rlogin.this.getConfig().getString("messages.login_message")) : Rlogin.this.getConfig().getString("messages.register_message");
                    player.sendMessage(Rlogin.this.translateColorCodes(message));
                }
            }
        }.runTaskTimer((Plugin)this, 0L, 100L);
    }

    public void onDisable() {
        if (this.jda != null) {
            this.jda.shutdown();
        }
        if (this.telegramPollingTask != null) {
            this.telegramPollingTask.cancel();
        }
    }

    private void startTelegramPolling() {
        this.telegramPollingTask = new BukkitRunnable(){

            public void run() {
                Rlogin.this.pollTelegramUpdates();
            }
        };
        this.telegramPollingTask.runTaskTimerAsynchronously((Plugin)this, 0L, 40L);
    }

    private void pollTelegramUpdates() {
        try {
            String url = "https://api.telegram.org/bot" + this.telegramBotToken + "/getUpdates?offset=" + (this.lastTelegramUpdate + 1L) + "&timeout=30";
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).timeout(Duration.ofSeconds(35L)).GET().build();
            HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            JsonObject json = JsonParser.parseString(response.body()).getAsJsonObject();
            if (json.get("ok").getAsBoolean()) {
                JsonArray updates = json.getAsJsonArray("result");
                for (JsonElement update : updates) {
                    JsonObject updateObj = update.getAsJsonObject();
                    long updateId = updateObj.get("update_id").getAsLong();
                    this.lastTelegramUpdate = Math.max(this.lastTelegramUpdate, updateId);
                    if (updateObj.has("callback_query")) {
                        this.handleTelegramCallback(updateObj.getAsJsonObject("callback_query"));
                        continue;
                    }
                    if (!updateObj.has("message")) continue;
                    this.handleTelegramMessage(updateObj.getAsJsonObject("message"));
                }
            }
        }
        catch (Exception e) {
            this.getLogger().warning("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0439 Telegram: " + e.getMessage());
        }
    }

    private void handleTelegramCallback(JsonObject callbackQuery) {
        try {
            String callbackId = callbackQuery.get("id").getAsString();
            String data = callbackQuery.get("data").getAsString();
            long chatId = callbackQuery.getAsJsonObject("message").getAsJsonObject("chat").get("id").getAsLong();
            long messageId = callbackQuery.getAsJsonObject("message").get("message_id").getAsLong();
            if (data.startsWith("accept-") || data.startsWith("reject-")) {
                String loginId = data.substring(data.indexOf("-") + 1);
                String playerName = this.pendingTgLogins.remove(loginId);
                if (playerName == null) {
                    this.answerTelegramCallback(callbackId, "\u042d\u0442\u043e\u0442 \u0437\u0430\u043f\u0440\u043e\u0441 \u0443\u0441\u0442\u0430\u0440\u0435\u043b.");
                    return;
                }
                Player player = Bukkit.getPlayerExact((String)playerName);
                if (player == null) {
                    this.answerTelegramCallback(callbackId, "\u0418\u0433\u0440\u043e\u043a \u043d\u0435 \u0432 \u0441\u0435\u0442\u0438.");
                    return;
                }
                if (data.startsWith("accept-")) {
                    Bukkit.getScheduler().runTask((Plugin)this, () -> {
                        this.setLoggedIn(player, true);
                        String ip = this.getPlayerIP(player);
                        if (ip != null) {
                            this.setIP(player, ip);
                        }
                        player.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.login_successful")));
                    });
                    this.answerTelegramCallback(callbackId, "\u0412\u0445\u043e\u0434 \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0451\u043d.");
                    this.editTelegramMessage(chatId, messageId, "\u0412\u0445\u043e\u0434 \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0451\u043d \u0434\u043b\u044f " + playerName);
                } else {
                    Bukkit.getScheduler().runTask((Plugin)this, () -> player.kickPlayer(this.translateColorCodes(this.getConfig().getString("messages.login_2fa_rejected"))));
                    this.answerTelegramCallback(callbackId, "\u0412\u0445\u043e\u0434 \u043e\u0442\u043a\u043b\u043e\u043d\u0451\u043d.");
                    this.editTelegramMessage(chatId, messageId, "\u0412\u0445\u043e\u0434 \u043e\u0442\u043a\u043b\u043e\u043d\u0451\u043d \u0434\u043b\u044f " + playerName);
                }
            }
        }
        catch (Exception e) {
            this.getLogger().warning("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 Telegram callback: " + e.getMessage());
        }
    }

    private void handleTelegramMessage(JsonObject message) {
        try {
            if (!message.has("text")) {
                return;
            }
            String text = message.get("text").getAsString();
            long chatId = message.getAsJsonObject("chat").get("id").getAsLong();
            String telegramId = String.valueOf(chatId);
            for (Map.Entry<String, String> entry : this.pendingTg2FACodes.entrySet()) {
                String playerName = entry.getKey();
                String code = entry.getValue();
                if (!text.equals(code)) continue;
                this.pendingTg2FACodes.remove(playerName);
                this.enableTg2FA(playerName, telegramId);
                Player player = Bukkit.getPlayerExact((String)playerName);
                if (player != null) {
                    Bukkit.getScheduler().runTask((Plugin)this, () -> player.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.addtg2fa_successful"))));
                }
                this.sendTelegramMessage(chatId, "Telegram 2FA \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0432\u043a\u043b\u044e\u0447\u0435\u043d\u0430 \u0434\u043b\u044f " + playerName + ".");
                return;
            }
            if (text.equalsIgnoreCase("/remove2fa")) {
                String playerName = null;
                for (String name : this.getTgDiscordIdMap().keySet()) {
                    if (!this.getTgDiscordId(name).equals(telegramId)) continue;
                    playerName = name;
                    break;
                }
                if (playerName == null) {
                    this.sendTelegramMessage(chatId, "\u0412\u0430\u0448 Telegram \u043d\u0435 \u043f\u0440\u0438\u0432\u044f\u0437\u0430\u043d \u043a \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0443 Minecraft.");
                    return;
                }
                String string = this.generate2FACode();
                this.pendingRemoveTg2FACodes.put(playerName, string);
                this.sendTelegramMessage(chatId, this.getConfig().getString("messages.telegram_remove2fa_code_sent").replace("%player%", playerName).replace("%code%", string));
            }
        }
        catch (Exception e) {
            this.getLogger().warning("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 Telegram \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f: " + e.getMessage());
        }
    }

    private void sendTelegramMessage(long chatId, String text) {
        try {
            String encodedText = URLEncoder.encode(text, StandardCharsets.UTF_8);
            String url = "https://api.telegram.org/bot" + this.telegramBotToken + "/sendMessage?chat_id=" + chatId + "&text=" + encodedText;
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).timeout(Duration.ofSeconds(10L)).GET().build();
            this.httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofString());
        }
        catch (Exception e) {
            this.getLogger().warning("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0435 Telegram \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f: " + e.getMessage());
        }
    }

    private void sendTelegramMessageWithButtons(long chatId, String text, String loginId) {
        try {
            JsonObject keyboard = new JsonObject();
            JsonArray inlineKeyboard = new JsonArray();
            JsonArray row = new JsonArray();
            JsonObject acceptButton = new JsonObject();
            acceptButton.addProperty("text", "\u041f\u0440\u0438\u043d\u044f\u0442\u044c");
            acceptButton.addProperty("callback_data", "accept-" + loginId);
            JsonObject rejectButton = new JsonObject();
            rejectButton.addProperty("text", "\u041e\u0442\u043a\u043b\u043e\u043d\u0438\u0442\u044c");
            rejectButton.addProperty("callback_data", "reject-" + loginId);
            row.add(acceptButton);
            row.add(rejectButton);
            inlineKeyboard.add(row);
            keyboard.add("inline_keyboard", inlineKeyboard);
            JsonObject requestBody = new JsonObject();
            requestBody.addProperty("chat_id", chatId);
            requestBody.addProperty("text", text);
            requestBody.add("reply_markup", keyboard);
            String url = "https://api.telegram.org/bot" + this.telegramBotToken + "/sendMessage";
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).header("Content-Type", "application/json").timeout(Duration.ofSeconds(10L)).POST(HttpRequest.BodyPublishers.ofString(requestBody.toString())).build();
            this.httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofString());
        }
        catch (Exception e) {
            this.getLogger().warning("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0435 Telegram \u043a\u043d\u043e\u043f\u043e\u043a: " + e.getMessage());
        }
    }

    private void answerTelegramCallback(String callbackId, String text) {
        try {
            String encodedText = URLEncoder.encode(text, StandardCharsets.UTF_8);
            String url = "https://api.telegram.org/bot" + this.telegramBotToken + "/answerCallbackQuery?callback_query_id=" + callbackId + "&text=" + encodedText;
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).timeout(Duration.ofSeconds(10L)).GET().build();
            this.httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofString());
        }
        catch (Exception e) {
            this.getLogger().warning("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0442\u0432\u0435\u0442\u0435 \u043d\u0430 Telegram callback: " + e.getMessage());
        }
    }

    private void editTelegramMessage(long chatId, long messageId, String text) {
        try {
            String encodedText = URLEncoder.encode(text, StandardCharsets.UTF_8);
            String url = "https://api.telegram.org/bot" + this.telegramBotToken + "/editMessageText?chat_id=" + chatId + "&message_id=" + messageId + "&text=" + encodedText;
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).timeout(Duration.ofSeconds(10L)).GET().build();
            this.httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofString());
        }
        catch (Exception e) {
            this.getLogger().warning("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0438 Telegram \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f: " + e.getMessage());
        }
    }

    private String getCountryFlagFromIP(String ip) {
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create("http://ip-api.com/json/" + ip)).timeout(Duration.ofSeconds(5L)).build();
            HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            JsonObject json = JsonParser.parseString(response.body()).getAsJsonObject();
            if (json.has("countryCode")) {
                String countryCode = json.get("countryCode").getAsString().toUpperCase();
                return countryCode.chars().mapToObj(ch -> String.valueOf(Character.toChars(127462 + (ch - 65)))).collect(Collectors.joining());
            }
            return "\ud83c\udff3\ufe0f";
        }
        catch (Exception e) {
            this.getLogger().warning("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0444\u043b\u0430\u0433 \u043f\u043e IP " + ip + ": " + e.getMessage());
            return "\ud83c\udff3\ufe0f";
        }
    }

    private void initializeConfigFile(File file) {
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                this.getLogger().severe("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u0444\u0430\u0439\u043b " + file.getName() + ": " + e.getMessage());
            }
        }
    }

    private void registerCommands(String ... commands) {
        for (String cmd : commands) {
            this.getCommand(cmd).setExecutor((CommandExecutor)this);
        }
    }

    private void setupDefaultMessages() {
        FileConfiguration config = this.getConfig();
        config.addDefault("auto_login.enabled", (Object)true);
        config.addDefault("login_attempts.max_attempts", (Object)3);
        config.addDefault("discord.enabled", (Object)false);
        config.addDefault("discord.bot_token", (Object)"YOUR_BOT_TOKEN_HERE");
        config.addDefault("telegram.enabled", (Object)false);
        config.addDefault("telegram.bot_token", (Object)"YOUR_TELEGRAM_BOT_TOKEN_HERE");
        config.addDefault("messages.register_message", (Object)"&c\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 /register \u0434\u043b\u044f \u043d\u0430\u0447\u0430\u043b\u0430 \u0438\u0433\u0440\u044b.");
        config.addDefault("messages.login_message", (Object)"&c\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 /login \u0434\u043b\u044f \u0432\u0445\u043e\u0434\u0430.");
        config.addDefault("messages.register_usage", (Object)"&c\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435: /register <\u043f\u0430\u0440\u043e\u043b\u044c> <\u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435_\u043f\u0430\u0440\u043e\u043b\u044f>");
        config.addDefault("messages.login_usage", (Object)"&c\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435: /login <\u043f\u0430\u0440\u043e\u043b\u044c>");
        config.addDefault("messages.already_registered", (Object)"&c\u0412\u044b \u0443\u0436\u0435 \u0437\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u043d\u044b. \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 /login <\u043f\u0430\u0440\u043e\u043b\u044c>.");
        config.addDefault("messages.passwords_do_not_match", (Object)"&c\u041f\u0430\u0440\u043e\u043b\u0438 \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u044e\u0442. \u041f\u043e\u043f\u0440\u043e\u0431\u0443\u0439\u0442\u0435 \u0441\u043d\u043e\u0432\u0430.");
        config.addDefault("messages.registration_successful", (Object)"&a\u0412\u044b \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0437\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u043b\u0438\u0441\u044c. \u0412\u043e\u0439\u0434\u0438\u0442\u0435 \u0441 \u043f\u043e\u043c\u043e\u0449\u044c\u044e /login <\u043f\u0430\u0440\u043e\u043b\u044c>.");
        config.addDefault("messages.not_registered", (Object)"&c\u0412\u044b \u043d\u0435 \u0437\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u043d\u044b. \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 /register <\u043f\u0430\u0440\u043e\u043b\u044c> <\u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435_\u043f\u0430\u0440\u043e\u043b\u044f>.");
        config.addDefault("messages.incorrect_password", (Object)"&c\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043f\u0430\u0440\u043e\u043b\u044c. \u041f\u043e\u043f\u044b\u0442\u043e\u043a \u043e\u0441\u0442\u0430\u043b\u043e\u0441\u044c: {0}");
        config.addDefault("messages.too_many_attempts", (Object)"&c\u0412\u044b \u043f\u0440\u0435\u0432\u044b\u0441\u0438\u043b\u0438 \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043f\u043e\u043f\u044b\u0442\u043e\u043a \u0432\u0445\u043e\u0434\u0430.");
        config.addDefault("messages.login_successful", (Object)"&a\u0412\u044b \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0432\u043e\u0448\u043b\u0438.");
        config.addDefault("messages.auto_login", (Object)"&a\u0412\u044b \u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438 \u0432\u043e\u0448\u043b\u0438.");
        config.addDefault("messages.command_blocked", (Object)"&c\u0412\u044b \u0434\u043e\u043b\u0436\u043d\u044b \u0432\u043e\u0439\u0442\u0438, \u0447\u0442\u043e\u0431\u044b \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u043a\u043e\u043c\u0430\u043d\u0434\u044b, \u043a\u0440\u043e\u043c\u0435 /login, /l, /register, /reg, /changepass, /add2fa, /remove2fa, /addtg2fa, /removetg2fa.");
        config.addDefault("messages.changepass_usage", (Object)"&c\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435: /changepass <\u0441\u0442\u0430\u0440\u044b\u0439_\u043f\u0430\u0440\u043e\u043b\u044c> <\u043d\u043e\u0432\u044b\u0439_\u043f\u0430\u0440\u043e\u043b\u044c>");
        config.addDefault("messages.changepass_successful", (Object)"&a\u041f\u0430\u0440\u043e\u043b\u044c \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0438\u0437\u043c\u0435\u043d\u0451\u043d.");
        config.addDefault("messages.rlchangepass_usage", (Object)"&c\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435: /rlchangepass <\u0438\u0433\u0440\u043e\u043a> <\u043d\u043e\u0432\u044b\u0439_\u043f\u0430\u0440\u043e\u043b\u044c>");
        config.addDefault("messages.rlchangepass_no_permission", (Object)"&c\u0423 \u0432\u0430\u0441 \u043d\u0435\u0442 \u043f\u0440\u0430\u0432 \u043d\u0430 \u044d\u0442\u0443 \u043a\u043e\u043c\u0430\u043d\u0434\u0443.");
        config.addDefault("messages.rlchangepass_player_not_found", (Object)"&c\u0418\u0433\u0440\u043e\u043a \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0438\u043b\u0438 \u043d\u0435 \u0437\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u043d.");
        config.addDefault("messages.rlchangepass_successful", (Object)"&a\u041f\u0430\u0440\u043e\u043b\u044c \u0434\u043b\u044f {0} \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0438\u0437\u043c\u0435\u043d\u0451\u043d.");
        config.addDefault("messages.rlogin_usage", (Object)"&c\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435: /rlogin reload");
        config.addDefault("messages.rlogin_no_permission", (Object)"&c\u0423 \u0432\u0430\u0441 \u043d\u0435\u0442 \u043f\u0440\u0430\u0432 \u043d\u0430 \u044d\u0442\u0443 \u043a\u043e\u043c\u0430\u043d\u0434\u0443.");
        config.addDefault("messages.rlogin_reload_successful", (Object)"&a\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f Rlogin \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u0430.");
        config.addDefault("messages.rlogin_reload_failed", (Object)"&c\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044e Rlogin.");
        config.addDefault("messages.2fa_disabled", (Object)"&c\u0414\u0432\u0443\u0445\u0444\u0430\u043a\u0442\u043e\u0440\u043d\u0430\u044f \u0430\u0443\u0442\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u044f \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u0430 \u043d\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u0435.");
        config.addDefault("messages.add2fa_usage", (Object)"&c\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435: /add2fa");
        config.addDefault("messages.add2fa_code_sent", (Object)"&a\u0412\u0430\u043c \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d \u043a\u043e\u0434 2FA. \u041e\u0442\u043f\u0440\u0430\u0432\u044c\u0442\u0435 \u0435\u0433\u043e \u0431\u043e\u0442\u0443 \u0432 Discord: %code%");
        config.addDefault("messages.add2fa_already_enabled", (Object)"&c2FA \u0443\u0436\u0435 \u0432\u043a\u043b\u044e\u0447\u0435\u043d\u0430 \u0434\u043b\u044f \u0432\u0430\u0448\u0435\u0433\u043e \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430.");
        config.addDefault("messages.add2fa_successful", (Object)"&a2FA \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0432\u043a\u043b\u044e\u0447\u0435\u043d\u0430.");
        config.addDefault("messages.remove2fa_usage", (Object)"&c\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435: /remove2fa <\u043a\u043e\u0434>");
        config.addDefault("messages.remove2fa_not_enabled", (Object)"&c2FA \u043d\u0435 \u0432\u043a\u043b\u044e\u0447\u0435\u043d\u0430 \u0434\u043b\u044f \u0432\u0430\u0448\u0435\u0433\u043e \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430.");
        config.addDefault("messages.remove2fa_code_sent", (Object)"&a\u041e\u0442\u043f\u0440\u0430\u0432\u044c\u0442\u0435 /remove2fa \u0432 Discord-\u0431\u043e\u0442, \u0447\u0442\u043e\u0431\u044b \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u043a\u043e\u0434, \u0437\u0430\u0442\u0435\u043c \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 /remove2fa <\u043a\u043e\u0434> \u0432 \u0438\u0433\u0440\u0435.");
        config.addDefault("messages.remove2fa_invalid_code", (Object)"&c\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0438\u043b\u0438 \u0438\u0441\u0442\u0451\u043a\u0448\u0438\u0439 \u043a\u043e\u0434 \u0434\u043b\u044f \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f 2FA.");
        config.addDefault("messages.remove2fa_successful", (Object)"&a2FA \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u0430.");
        config.addDefault("messages.discord_code_invalid", (Object)"&c\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0438\u043b\u0438 \u0438\u0441\u0442\u0451\u043a\u0448\u0438\u0439 \u043a\u043e\u0434 2FA.");
        config.addDefault("messages.discord_remove2fa_code_sent", (Object)"\u041a\u043e\u0434 \u0434\u043b\u044f \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f 2FA \u0434\u043b\u044f %player%: %code%. \u0412\u0432\u0435\u0434\u0438\u0442\u0435 /remove2fa <\u043a\u043e\u0434> \u0432 \u0438\u0433\u0440\u0435.");
        config.addDefault("messages.discord_login_request", (Object)"\u0417\u0430\u0444\u0438\u043a\u0441\u0438\u0440\u043e\u0432\u0430\u043d \u0432\u0445\u043e\u0434 \u043d\u0430 \u0432\u0430\u0448 \u0430\u043a\u043a\u0430\u0443\u043d\u0442 %player% \u0441 IP %ip% (%country_flag%). \u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0434\u0438\u0442\u0435 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0435:");
        config.addDefault("messages.login_2fa_pending", (Object)"&c\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0434\u0438\u0442\u0435 \u0432\u0445\u043e\u0434 \u0447\u0435\u0440\u0435\u0437 2FA \u0432 Discord/Telegram.");
        config.addDefault("messages.login_2fa_rejected", (Object)"&c\u0412\u0445\u043e\u0434 \u043e\u0442\u043a\u043b\u043e\u043d\u0451\u043d \u0447\u0435\u0440\u0435\u0437 Discord/Telegram.");
        config.addDefault("messages.telegram_disabled", (Object)"&cTelegram 2FA \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u0430 \u043d\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u0435.");
        config.addDefault("messages.addtg2fa_usage", (Object)"&c\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435: /addtg2fa");
        config.addDefault("messages.addtg2fa_code_sent", (Object)"&a\u0412\u0430\u043c \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d \u043a\u043e\u0434 2FA. \u041e\u0442\u043f\u0440\u0430\u0432\u044c\u0442\u0435 \u0435\u0433\u043e \u0431\u043e\u0442\u0443 \u0432 Telegram: %code%");
        config.addDefault("messages.addtg2fa_already_enabled", (Object)"&cTelegram 2FA \u0443\u0436\u0435 \u0432\u043a\u043b\u044e\u0447\u0435\u043d\u0430 \u0434\u043b\u044f \u0432\u0430\u0448\u0435\u0433\u043e \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430.");
        config.addDefault("messages.addtg2fa_successful", (Object)"&aTelegram 2FA \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0432\u043a\u043b\u044e\u0447\u0435\u043d\u0430.");
        config.addDefault("messages.removetg2fa_usage", (Object)"&c\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435: /removetg2fa <\u043a\u043e\u0434>");
        config.addDefault("messages.removetg2fa_not_enabled", (Object)"&cTelegram 2FA \u043d\u0435 \u0432\u043a\u043b\u044e\u0447\u0435\u043d\u0430 \u0434\u043b\u044f \u0432\u0430\u0448\u0435\u0433\u043e \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430.");
        config.addDefault("messages.removetg2fa_code_sent", (Object)"&a\u041e\u0442\u043f\u0440\u0430\u0432\u044c\u0442\u0435 /remove2fa \u0432 Telegram-\u0431\u043e\u0442, \u0447\u0442\u043e\u0431\u044b \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u043a\u043e\u0434, \u0437\u0430\u0442\u0435\u043c \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 /removetg2fa <\u043a\u043e\u0434> \u0432 \u0438\u0433\u0440\u0435.");
        config.addDefault("messages.removetg2fa_invalid_code", (Object)"&c\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0438\u043b\u0438 \u0438\u0441\u0442\u0451\u043a\u0448\u0438\u0439 \u043a\u043e\u0434 \u0434\u043b\u044f \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f Telegram 2FA.");
        config.addDefault("messages.removetg2fa_successful", (Object)"&aTelegram 2FA \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u0430.");
        config.addDefault("messages.telegram_remove2fa_code_sent", (Object)"\u041a\u043e\u0434 \u0434\u043b\u044f \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f Telegram 2FA \u0434\u043b\u044f %player%: %code%. \u0412\u0432\u0435\u0434\u0438\u0442\u0435 /removetg2fa <\u043a\u043e\u0434> \u0432 \u0438\u0433\u0440\u0435.");
        config.addDefault("messages.telegram_login_request", (Object)"\u0417\u0430\u0444\u0438\u043a\u0441\u0438\u0440\u043e\u0432\u0430\u043d \u0432\u0445\u043e\u0434 \u043d\u0430 \u0432\u0430\u0448 \u0430\u043a\u043a\u0430\u0443\u043d\u0442 %player% \u0441 IP %ip% (%country_flag%). \u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0434\u0438\u0442\u0435 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0435:");
        config.options().copyDefaults(true);
        this.saveConfig();
    }

    private String translateColorCodes(String message) {
        return message != null ? ChatColor.translateAlternateColorCodes((char)'&', (String)message) : "";
    }

    private String generateSalt() {
        byte[] salt = new byte[16];
        new SecureRandom().nextBytes(salt);
        return Base64.getEncoder().encodeToString(salt);
    }

    private String hashPassword(String password, String salt) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(salt.getBytes(StandardCharsets.UTF_8));
            byte[] hash = md.digest(password.getBytes(StandardCharsets.UTF_8));
            return Base64.getEncoder().encodeToString(hash);
        }
        catch (NoSuchAlgorithmException e) {
            this.getLogger().severe("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0445\u0435\u0448\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u0430\u0440\u043e\u043b\u044c: " + e.getMessage());
            return null;
        }
    }

    private String generate2FACode() {
        return UUID.randomUUID().toString().substring(0, 8);
    }

    private void reloadConfigs() {
        this.reloadConfig();
        if (this.getConfig().getBoolean("discord.enabled", false) && this.jda == null) {
            try {
                this.jda = JDABuilder.createDefault(this.getConfig().getString("discord.bot_token")).addEventListeners(new DiscordListener(this)).build();
                this.jda.awaitReady();
                this.getLogger().info("Discord-\u0431\u043e\u0442 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u0435\u0440\u0435\u0437\u0430\u043f\u0443\u0449\u0435\u043d \u043f\u043e\u0441\u043b\u0435 \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u043a\u043e\u043d\u0444\u0438\u0433\u0430.");
            }
            catch (Exception e) {
                this.getLogger().warning("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0435\u0440\u0435\u0437\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u044c Discord-\u0431\u043e\u0442\u0430: " + e.getMessage());
                this.jda = null;
            }
        } else if (!this.getConfig().getBoolean("discord.enabled", false) && this.jda != null) {
            this.jda.shutdown();
            this.jda = null;
            this.getLogger().info("Discord-\u0431\u043e\u0442 \u043e\u0442\u043a\u043b\u044e\u0447\u0451\u043d \u043f\u043e\u0441\u043b\u0435 \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u043a\u043e\u043d\u0444\u0438\u0433\u0430.");
        }
        if (this.getConfig().getBoolean("telegram.enabled", false) && this.telegramPollingTask == null) {
            this.telegramBotToken = this.getConfig().getString("telegram.bot_token");
            if (this.telegramBotToken != null && !this.telegramBotToken.isEmpty() && !this.telegramBotToken.equals("YOUR_TELEGRAM_BOT_TOKEN_HERE")) {
                this.startTelegramPolling();
                this.getLogger().info("Telegram-\u0431\u043e\u0442 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u0435\u0440\u0435\u0437\u0430\u043f\u0443\u0449\u0435\u043d \u043f\u043e\u0441\u043b\u0435 \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u043a\u043e\u043d\u0444\u0438\u0433\u0430.");
            }
        } else if (!this.getConfig().getBoolean("telegram.enabled", false) && this.telegramPollingTask != null) {
            this.telegramPollingTask.cancel();
            this.telegramPollingTask = null;
            this.getLogger().info("Telegram-\u0431\u043e\u0442 \u043e\u0442\u043a\u043b\u044e\u0447\u0451\u043d \u043f\u043e\u0441\u043b\u0435 \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u043a\u043e\u043d\u0444\u0438\u0433\u0430.");
        }
    }

    private boolean is2FAEnabled(String playerName) {
        return this.has2FA(playerName) || this.hasTg2FA(playerName);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args2) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (label.equalsIgnoreCase("login") || label.equalsIgnoreCase("l")) {
                String salt;
                String playerName;
                if (args2.length != 1) {
                    player.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.login_usage")));
                    return false;
                }
                Map<String, String> passwords = this.getPasswords();
                if (!passwords.containsKey(playerName = player.getName())) {
                    player.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.not_registered")));
                    return false;
                }
                storedData = passwords.get(playerName).split(":");
                String storedHash = storedData[0];
                String string = salt = storedData.length > 1 ? storedData[1] : "";
                if (storedHash.equals(this.hashPassword(args2[0], salt))) {
                    boolean needsDiscord2FA;
                    this.loginAttempts.remove(playerName);
                    String ip = this.getPlayerIP(player);
                    boolean needsTelegram2FA = this.getConfig().getBoolean("telegram.enabled", false) && this.hasTg2FA(playerName) && this.telegramBotToken != null;
                    boolean bl = needsDiscord2FA = this.getConfig().getBoolean("discord.enabled", false) && this.has2FA(playerName) && this.jda != null;
                    if (!this.getConfig().getBoolean("auto_login.enabled", true)) {
                        if (needsTelegram2FA) {
                            String countryFlag = this.getCountryFlagFromIP(ip);
                            this.sendTg2FARequest(player, ip, countryFlag);
                            player.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.login_2fa_pending")));
                        } else if (needsDiscord2FA) {
                            String countryFlag = this.getCountryFlagFromIP(ip);
                            this.send2FARequest(player, ip, countryFlag);
                            player.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.login_2fa_pending")));
                        } else {
                            this.setLoggedIn(player, true);
                            player.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.login_successful")));
                            if (ip != null) {
                                this.setIP(player, ip);
                            }
                        }
                    } else if (!this.isIPValid(player, ip)) {
                        if (needsTelegram2FA) {
                            String countryFlag = this.getCountryFlagFromIP(ip);
                            this.sendTg2FARequest(player, ip, countryFlag);
                            player.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.login_2fa_pending")));
                        } else if (needsDiscord2FA) {
                            String countryFlag = this.getCountryFlagFromIP(ip);
                            this.send2FARequest(player, ip, countryFlag);
                            player.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.login_2fa_pending")));
                        } else {
                            this.setLoggedIn(player, true);
                            player.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.login_successful")));
                            if (ip != null) {
                                this.setIP(player, ip);
                            }
                        }
                    } else {
                        this.setLoggedIn(player, true);
                        player.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.login_successful")));
                        if (ip != null) {
                            this.setIP(player, ip);
                        }
                    }
                } else {
                    int maxAttempts;
                    int attempts = this.loginAttempts.getOrDefault(playerName, 0) + 1;
                    if (attempts >= (maxAttempts = this.getConfig().getInt("login_attempts.max_attempts", 3))) {
                        this.loginAttempts.remove(playerName);
                        String kickMessage = this.translateColorCodes(this.getConfig().getString("messages.too_many_attempts"));
                        Bukkit.getScheduler().runTask((Plugin)this, () -> player.kickPlayer(kickMessage));
                    } else {
                        this.loginAttempts.put(playerName, attempts);
                        int remaining = maxAttempts - attempts;
                        String message = this.getConfig().getString("messages.incorrect_password").replace("{0}", String.valueOf(remaining));
                        player.sendMessage(this.translateColorCodes(message));
                    }
                }
            } else if (label.equalsIgnoreCase("register") || label.equalsIgnoreCase("reg")) {
                if (args2.length != 2) {
                    player.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.register_usage")));
                    return false;
                }
                playerName = player.getName();
                if (this.getPasswords().containsKey(playerName)) {
                    player.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.already_registered")));
                    return false;
                }
                if (!args2[0].equals(args2[1])) {
                    player.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.passwords_do_not_match")));
                    return false;
                }
                this.setPassword(player, args2[0]);
                player.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.registration_successful")));
            } else if (label.equalsIgnoreCase("changepass")) {
                String salt;
                if (args2.length != 2) {
                    player.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.changepass_usage")));
                    return false;
                }
                playerName = player.getName();
                Map<String, String> passwords = this.getPasswords();
                if (!passwords.containsKey(playerName)) {
                    player.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.not_registered")));
                    return false;
                }
                storedData = passwords.get(playerName).split(":");
                String storedHash = storedData[0];
                String string = salt = storedData.length > 1 ? storedData[1] : "";
                if (!storedHash.equals(this.hashPassword(args2[0], salt))) {
                    player.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.incorrect_password")));
                    return false;
                }
                this.setPassword(player, args2[1]);
                player.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.changepass_successful")));
            } else if (label.equalsIgnoreCase("add2fa")) {
                if (!this.getConfig().getBoolean("discord.enabled", false) || this.jda == null) {
                    player.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.2fa_disabled")));
                    return false;
                }
                if (args2.length != 0) {
                    player.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.add2fa_usage")));
                    return false;
                }
                playerName = player.getName();
                if (this.has2FA(playerName)) {
                    player.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.add2fa_already_enabled")));
                    return false;
                }
                code = this.generate2FACode();
                this.pending2FACodes.put(playerName, code);
                player.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.add2fa_code_sent").replace("%code%", code)));
            } else if (label.equalsIgnoreCase("remove2fa")) {
                if (!this.getConfig().getBoolean("discord.enabled", false) || this.jda == null) {
                    player.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.2fa_disabled")));
                    return false;
                }
                playerName = player.getName();
                if (!this.has2FA(playerName)) {
                    player.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.remove2fa_not_enabled")));
                    return false;
                }
                if (args2.length != 1) {
                    player.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.remove2fa_usage")));
                    player.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.remove2fa_code_sent")));
                    return false;
                }
                code = args2[0];
                if (code.equals(this.pendingRemove2FACodes.get(playerName))) {
                    this.pendingRemove2FACodes.remove(playerName);
                    this.remove2FA(playerName);
                    player.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.remove2fa_successful")));
                } else {
                    player.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.remove2fa_invalid_code")));
                }
            } else if (label.equalsIgnoreCase("addtg2fa")) {
                if (!this.getConfig().getBoolean("telegram.enabled", false) || this.telegramBotToken == null) {
                    player.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.telegram_disabled")));
                    return false;
                }
                if (args2.length != 0) {
                    player.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.addtg2fa_usage")));
                    return false;
                }
                playerName = player.getName();
                if (this.hasTg2FA(playerName)) {
                    player.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.addtg2fa_already_enabled")));
                    return false;
                }
                code = this.generate2FACode();
                this.pendingTg2FACodes.put(playerName, code);
                player.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.addtg2fa_code_sent").replace("%code%", code)));
            } else if (label.equalsIgnoreCase("removetg2fa")) {
                if (!this.getConfig().getBoolean("telegram.enabled", false) || this.telegramBotToken == null) {
                    player.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.telegram_disabled")));
                    return false;
                }
                playerName = player.getName();
                if (!this.hasTg2FA(playerName)) {
                    player.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.removetg2fa_not_enabled")));
                    return false;
                }
                if (args2.length != 1) {
                    player.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.removetg2fa_usage")));
                    player.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.removetg2fa_code_sent")));
                    return false;
                }
                code = args2[0];
                if (code.equals(this.pendingRemoveTg2FACodes.get(playerName))) {
                    this.pendingRemoveTg2FACodes.remove(playerName);
                    this.removeTg2FA(playerName);
                    player.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.removetg2fa_successful")));
                } else {
                    player.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.removetg2fa_invalid_code")));
                }
            }
        }
        if (label.equalsIgnoreCase("rlchangepass")) {
            if (!sender.hasPermission(PERMISSION_ADMIN)) {
                sender.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.rlchangepass_no_permission")));
                return false;
            }
            if (args2.length != 2) {
                sender.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.rlchangepass_usage")));
                return false;
            }
            String targetPlayerName = args2[0];
            if (!this.getPasswords().containsKey(targetPlayerName)) {
                sender.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.rlchangepass_player_not_found")));
                return false;
            }
            Player targetPlayer = Bukkit.getPlayerExact((String)targetPlayerName);
            if (targetPlayer != null) {
                this.setPassword(targetPlayer, args2[1]);
            } else {
                String salt = this.generateSalt();
                String hashedPassword = this.hashPassword(args2[1], salt);
                if (hashedPassword != null) {
                    this.passwordsConfig.set("passwords." + targetPlayerName, (Object)(hashedPassword + ":" + salt));
                    this.savePasswordsConfig();
                }
            }
            sender.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.rlchangepass_successful").replace("{0}", targetPlayerName)));
        } else if (label.equalsIgnoreCase("rlogin")) {
            if (!sender.hasPermission(PERMISSION_ADMIN)) {
                sender.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.rlogin_no_permission")));
                return false;
            }
            if (args2.length != 1 || !args2[0].equalsIgnoreCase("reload")) {
                sender.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.rlogin_usage")));
                return false;
            }
            try {
                this.reloadConfigs();
                sender.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.rlogin_reload_successful")));
            }
            catch (Exception e) {
                sender.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.rlogin_reload_failed")));
                this.getLogger().severe("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u043a\u043e\u043d\u0444\u0438\u0433: " + e.getMessage());
            }
        }
        return true;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        String ip = this.getPlayerIP(player);
        String playerName = player.getName();
        this.loginAttempts.remove(playerName);
        if (this.getConfig().getBoolean("auto_login.enabled", true) && ip != null && this.isIPValid(player, ip)) {
            this.setLoggedIn(player, true);
            player.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.auto_login")));
            this.setIP(player, ip);
        } else {
            String message = this.getPasswords().containsKey(playerName) ? this.getConfig().getString("messages.login_message") : this.getConfig().getString("messages.register_message");
            player.sendMessage(this.translateColorCodes(message));
            this.setLoggedIn(player, false);
        }
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent e) {
        if (!this.isLoggedIn(e.getPlayer())) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent e) {
        if (!this.isLoggedIn(e.getPlayer())) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent e) {
        if (!this.isLoggedIn(e.getPlayer())) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerDamage(EntityDamageEvent e) {
        Player p;
        Entity entity = e.getEntity();
        if (entity instanceof Player && !this.isLoggedIn(p = (Player)entity)) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerDropItem(PlayerDropItemEvent e) {
        if (!this.isLoggedIn(e.getPlayer())) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerCommand(PlayerCommandPreprocessEvent event) {
        Player player = event.getPlayer();
        String command = event.getMessage().toLowerCase().split(" ")[0].substring(1);
        if (HIDDEN_COMMANDS.contains(command)) {
            event.setCancelled(true);
            String[] args2 = event.getMessage().split(" ");
            String cmdLabel = args2[0].substring(1);
            CharSequence[] cmdArgs = args2.length > 1 ? Arrays.copyOfRange(args2, 1, args2.length) : new String[]{};
            Bukkit.dispatchCommand((CommandSender)player, (String)(cmdLabel + " " + String.join((CharSequence)" ", cmdArgs)));
            return;
        }
        if (!this.isLoggedIn(player) && !ALLOWED_COMMANDS.contains(command)) {
            event.setCancelled(true);
            player.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.command_blocked")));
        }
    }

    public boolean isLoggedIn(Player player) {
        return this.loggedInPlayers.getOrDefault(player.getName(), false);
    }

    public void setLoggedIn(Player player, boolean loggedIn) {
        this.loggedInPlayers.put(player.getName(), loggedIn);
        if (loggedIn) {
            this.loginAttempts.remove(player.getName());
        }
    }

    public Map<String, String> getPasswords() {
        HashMap<String, String> passwords = new HashMap<String, String>();
        if (this.passwordsConfig.contains(PASSWORDS_PATH)) {
            for (String key : this.passwordsConfig.getConfigurationSection(PASSWORDS_PATH).getKeys(false)) {
                passwords.put(key, this.passwordsConfig.getString("passwords." + key));
            }
        }
        return passwords;
    }

    public void setPassword(Player player, String password) {
        String salt = this.generateSalt();
        String hashedPassword = this.hashPassword(password, salt);
        if (hashedPassword != null) {
            this.passwordsConfig.set("passwords." + player.getName(), (Object)(hashedPassword + ":" + salt));
            this.savePasswordsConfig();
        }
    }

    private void savePasswordsConfig() {
        try {
            this.passwordsConfig.save(this.passwordsFile);
        }
        catch (IOException e) {
            this.getLogger().severe("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c passwords.yml: " + e.getMessage());
        }
    }

    public boolean isIPValid(Player player, String ip) {
        String lastLoginString = this.ipConfig.getString("ips." + player.getName() + "." + ip);
        if (lastLoginString == null) {
            return false;
        }
        try {
            long lastLogin = Long.parseLong(lastLoginString);
            return System.currentTimeMillis() - lastLogin < 172800000L;
        }
        catch (NumberFormatException e) {
            this.getLogger().warning("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439 \u0448\u0442\u0430\u043c\u043f \u0432 ips.yml \u0434\u043b\u044f " + player.getName() + ": " + lastLoginString);
            return false;
        }
    }

    public void setIP(Player player, String ip) {
        this.ipConfig.set("ips." + player.getName() + "." + ip, (Object)String.valueOf(System.currentTimeMillis()));
        this.saveIPConfig();
    }

    private void saveIPConfig() {
        try {
            this.ipConfig.save(this.ipFile);
        }
        catch (IOException e) {
            this.getLogger().severe("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c ips.yml: " + e.getMessage());
        }
    }

    private String getPlayerIP(Player player) {
        try {
            return player.getAddress().getAddress().getHostAddress();
        }
        catch (NullPointerException e) {
            this.getLogger().warning("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c IP \u0434\u043b\u044f " + player.getName());
            return null;
        }
    }

    public boolean has2FA(String playerName) {
        return this.twoFaConfig.contains("2fa." + playerName);
    }

    public void enable2FA(String playerName, String discordId) {
        this.twoFaConfig.set("2fa." + playerName, (Object)discordId);
        this.saveConfig(this.twoFaConfig, this.twoFaFile);
    }

    public void remove2FA(String playerName) {
        this.twoFaConfig.set("2fa." + playerName, null);
        this.saveConfig(this.twoFaConfig, this.twoFaFile);
    }

    public String getDiscordId(String playerName) {
        return this.twoFaConfig.getString("2fa." + playerName);
    }

    public boolean hasTg2FA(String playerName) {
        return this.tgTwoFaConfig.contains("2fa." + playerName);
    }

    public void enableTg2FA(String playerName, String telegramId) {
        this.tgTwoFaConfig.set("2fa." + playerName, (Object)telegramId);
        this.saveConfig(this.tgTwoFaConfig, this.tgTwoFaFile);
    }

    public void removeTg2FA(String playerName) {
        this.tgTwoFaConfig.set("2fa." + playerName, null);
        this.saveConfig(this.tgTwoFaConfig, this.tgTwoFaFile);
    }

    public String getTgDiscordId(String playerName) {
        return this.tgTwoFaConfig.getString("2fa." + playerName);
    }

    private void saveConfig(FileConfiguration config, File file) {
        try {
            config.save(file);
        }
        catch (IOException e) {
            this.getLogger().severe("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0444\u0430\u0439\u043b: " + e.getMessage());
        }
    }

    public void send2FARequest(Player player, String ip, String countryFlag) {
        String playerName = player.getName();
        String discordId = this.getDiscordId(playerName);
        if (discordId == null) {
            return;
        }
        String loginId = UUID.randomUUID().toString();
        this.pendingLogins.put(loginId, playerName);
        String message = this.getConfig().getString("messages.discord_login_request").replace("%player%", playerName).replace("%ip%", ip).replace("%country_flag%", countryFlag);
        this.jda.retrieveUserById(discordId).queue(user -> user.openPrivateChannel().queue(channel -> ((MessageCreateAction)channel.sendMessage(message).setActionRow(Button.success("accept-" + loginId, "\u041f\u0440\u0438\u043d\u044f\u0442\u044c"), Button.danger("reject-" + loginId, "\u041e\u0442\u043a\u043b\u043e\u043d\u0438\u0442\u044c"))).queue()));
    }

    public void sendTg2FARequest(Player player, String ip, String countryFlag) {
        String playerName = player.getName();
        String telegramId = this.getTgDiscordId(playerName);
        if (telegramId == null) {
            return;
        }
        String loginId = UUID.randomUUID().toString();
        this.pendingTgLogins.put(loginId, playerName);
        String message = this.getConfig().getString("messages.telegram_login_request").replace("%player%", playerName).replace("%ip%", ip).replace("%country_flag%", countryFlag);
        try {
            long chatId = Long.parseLong(telegramId);
            this.sendTelegramMessageWithButtons(chatId, message, loginId);
        }
        catch (NumberFormatException e) {
            this.getLogger().warning("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 Telegram ID \u0434\u043b\u044f " + playerName + ": " + telegramId);
        }
    }

    private Map<String, String> getTgDiscordIdMap() {
        HashMap<String, String> telegramIds = new HashMap<String, String>();
        if (this.tgTwoFaConfig.contains(TWO_FA_PATH)) {
            for (String key : this.tgTwoFaConfig.getConfigurationSection(TWO_FA_PATH).getKeys(false)) {
                telegramIds.put(key, this.tgTwoFaConfig.getString("2fa." + key));
            }
        }
        return telegramIds;
    }

    public class DiscordListener
    extends ListenerAdapter {
        private final Rlogin plugin;

        public DiscordListener(Rlogin plugin) {
            this.plugin = plugin;
        }

        @Override
        public void onButtonInteraction(ButtonInteractionEvent event) {
            String buttonId = event.getButton().getId();
            if (buttonId.startsWith("accept-") || buttonId.startsWith("reject-")) {
                String loginId = buttonId.substring(buttonId.indexOf("-") + 1);
                String playerName = Rlogin.this.pendingLogins.remove(loginId);
                if (playerName == null) {
                    event.reply("\u042d\u0442\u043e\u0442 \u0437\u0430\u043f\u0440\u043e\u0441 \u0443\u0441\u0442\u0430\u0440\u0435\u043b.").setEphemeral(true).queue();
                    return;
                }
                Player player = Bukkit.getPlayerExact((String)playerName);
                if (player == null) {
                    event.reply("\u0418\u0433\u0440\u043e\u043a \u043d\u0435 \u0432 \u0441\u0435\u0442\u0438.").setEphemeral(true).queue();
                    return;
                }
                if (buttonId.startsWith("accept-")) {
                    this.plugin.setLoggedIn(player, true);
                    String ip = this.plugin.getPlayerIP(player);
                    if (ip != null) {
                        this.plugin.setIP(player, ip);
                    }
                    player.sendMessage(Rlogin.this.translateColorCodes(this.plugin.getConfig().getString("messages.login_successful")));
                    event.reply("\u0412\u0445\u043e\u0434 \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0451\u043d.").setEphemeral(true).queue();
                } else {
                    Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> player.kickPlayer(Rlogin.this.translateColorCodes(this.plugin.getConfig().getString("messages.login_2fa_rejected"))));
                    event.reply("\u0412\u0445\u043e\u0434 \u043e\u0442\u043a\u043b\u043e\u043d\u0451\u043d.").setEphemeral(true).queue();
                }
            }
        }

        @Override
        public void onMessageReceived(MessageReceivedEvent event) {
            if (event.getAuthor().isBot()) {
                return;
            }
            String message = event.getMessage().getContentRaw();
            String discordId = event.getAuthor().getId();
            for (Map.Entry<String, String> entry : Rlogin.this.pending2FACodes.entrySet()) {
                String playerName = entry.getKey();
                String code = entry.getValue();
                if (!message.equals(code)) continue;
                Rlogin.this.pending2FACodes.remove(playerName);
                Rlogin.this.enable2FA(playerName, discordId);
                Player player = Bukkit.getPlayerExact((String)playerName);
                if (player != null) {
                    player.sendMessage(Rlogin.this.translateColorCodes(Rlogin.this.getConfig().getString("messages.add2fa_successful")));
                }
                event.getChannel().sendMessage("2FA \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0432\u043a\u043b\u044e\u0447\u0435\u043d\u0430 \u0434\u043b\u044f " + playerName + ".").queue();
                return;
            }
            if (message.equalsIgnoreCase("/remove2fa")) {
                String playerName = null;
                for (String name : this.getDiscordIdMap().keySet()) {
                    if (!Rlogin.this.getDiscordId(name).equals(discordId)) continue;
                    playerName = name;
                    break;
                }
                if (playerName == null) {
                    event.getChannel().sendMessage("\u0412\u0430\u0448 Discord \u043d\u0435 \u043f\u0440\u0438\u0432\u044f\u0437\u0430\u043d \u043a \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0443 Minecraft.").queue();
                    return;
                }
                String string = Rlogin.this.generate2FACode();
                Rlogin.this.pendingRemove2FACodes.put(playerName, string);
                event.getChannel().sendMessage(Rlogin.this.getConfig().getString("messages.discord_remove2fa_code_sent").replace("%player%", playerName).replace("%code%", string)).queue();
            }
        }

        private Map<String, String> getDiscordIdMap() {
            HashMap<String, String> discordIds = new HashMap<String, String>();
            if (Rlogin.this.twoFaConfig.contains(Rlogin.TWO_FA_PATH)) {
                for (String key : Rlogin.this.twoFaConfig.getConfigurationSection(Rlogin.TWO_FA_PATH).getKeys(false)) {
                    discordIds.put(key, Rlogin.this.twoFaConfig.getString("2fa." + key));
                }
            }
            return discordIds;
        }
    }
}

