/*
 * Decompiled with CFR 0.152.
 */
package RASMI.rlogin.jda.jda.api.entities;

import RASMI.rlogin.jda.jda.api.JDA;
import RASMI.rlogin.jda.jda.api.Permission;
import RASMI.rlogin.jda.jda.api.entities.Guild;
import RASMI.rlogin.jda.jda.api.entities.Member;
import RASMI.rlogin.jda.jda.api.entities.Message;
import RASMI.rlogin.jda.jda.api.entities.channel.middleman.GuildChannel;
import RASMI.rlogin.jda.jda.api.entities.channel.middleman.MessageChannel;
import RASMI.rlogin.jda.jda.api.entities.channel.unions.MessageChannelUnion;
import RASMI.rlogin.jda.jda.api.exceptions.InsufficientPermissionException;
import RASMI.rlogin.jda.jda.api.requests.RestAction;
import RASMI.rlogin.jda.jda.api.requests.Route;
import RASMI.rlogin.jda.jda.internal.JDAImpl;
import RASMI.rlogin.jda.jda.internal.entities.ReceivedMessage;
import RASMI.rlogin.jda.jda.internal.requests.CompletedRestAction;
import RASMI.rlogin.jda.jda.internal.requests.RestActionImpl;
import RASMI.rlogin.jda.jda.internal.utils.Checks;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MessageReference {
    private final long messageId;
    private final long channelId;
    private final long guildId;
    private final JDA api;
    private final MessageChannel channel;
    private final Guild guild;
    private Message referencedMessage;

    public MessageReference(long messageId, long channelId, long guildId, @Nullable Message referencedMessage, JDA api) {
        this.messageId = messageId;
        this.channelId = channelId;
        this.guildId = guildId;
        this.referencedMessage = referencedMessage;
        this.channel = guildId == 0L ? api.getPrivateChannelById(channelId) : api.getChannelById(MessageChannel.class, channelId);
        this.guild = api.getGuildById(guildId);
        this.api = api;
    }

    @Nonnull
    public RestAction<Message> resolve() {
        return this.resolve(true);
    }

    @Nonnull
    public RestAction<Message> resolve(boolean update) {
        this.checkPermission(Permission.VIEW_CHANNEL);
        this.checkPermission(Permission.MESSAGE_HISTORY);
        if (this.channel == null) {
            throw new IllegalStateException("Cannot resolve a message without a channel present.");
        }
        JDAImpl jda = (JDAImpl)this.getJDA();
        Message referenced = this.getMessage();
        if (referenced != null && !update) {
            return new CompletedRestAction<Message>((JDA)jda, referenced);
        }
        Route.CompiledRoute route = Route.Messages.GET_MESSAGE.compile(this.getChannelId(), this.getMessageId());
        return new RestActionImpl<Message>((JDA)jda, route, (response, request) -> {
            ReceivedMessage created = jda.getEntityBuilder().createMessageWithChannel(response.getObject(), this.channel, false);
            this.referencedMessage = created;
            return created;
        });
    }

    @Nullable
    public Message getMessage() {
        return this.referencedMessage;
    }

    @Nullable
    public MessageChannelUnion getChannel() {
        return (MessageChannelUnion)this.channel;
    }

    @Nullable
    public Guild getGuild() {
        return this.guild;
    }

    public long getMessageIdLong() {
        return this.messageId;
    }

    public long getChannelIdLong() {
        return this.channelId;
    }

    public long getGuildIdLong() {
        return this.guildId;
    }

    @Nonnull
    public String getMessageId() {
        return Long.toUnsignedString(this.getMessageIdLong());
    }

    @Nonnull
    public String getChannelId() {
        return Long.toUnsignedString(this.getChannelIdLong());
    }

    @Nonnull
    public String getGuildId() {
        return Long.toUnsignedString(this.getGuildIdLong());
    }

    @Nonnull
    public JDA getJDA() {
        return this.api;
    }

    private void checkPermission(Permission permission) {
        if (this.guild == null || !(this.channel instanceof GuildChannel)) {
            return;
        }
        Member selfMember = this.guild.getSelfMember();
        GuildChannel guildChannel = (GuildChannel)((Object)this.channel);
        Checks.checkAccess(selfMember, guildChannel);
        if (!selfMember.hasPermission(guildChannel, permission)) {
            throw new InsufficientPermissionException(guildChannel, permission);
        }
    }
}

