/*
 * Decompiled with CFR 0.152.
 */
package RASMI.rlogin.jda.jda.api.interactions.commands;

import RASMI.rlogin.jda.jda.api.entities.Member;
import RASMI.rlogin.jda.jda.api.entities.Role;
import RASMI.rlogin.jda.jda.api.entities.User;
import RASMI.rlogin.jda.jda.api.interactions.Interaction;
import RASMI.rlogin.jda.jda.api.interactions.commands.Command;
import RASMI.rlogin.jda.jda.api.interactions.commands.OptionMapping;
import RASMI.rlogin.jda.jda.api.interactions.commands.OptionType;
import RASMI.rlogin.jda.jda.internal.utils.Checks;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface CommandInteractionPayload
extends Interaction {
    @Nonnull
    public Command.Type getCommandType();

    @Nonnull
    public String getName();

    @Nullable
    public String getSubcommandName();

    @Nullable
    public String getSubcommandGroup();

    @Nonnull
    default public String getFullCommandName() {
        StringBuilder builder = new StringBuilder(this.getName());
        if (this.getSubcommandGroup() != null) {
            builder.append(' ').append(this.getSubcommandGroup());
        }
        if (this.getSubcommandName() != null) {
            builder.append(' ').append(this.getSubcommandName());
        }
        return builder.toString();
    }

    @Nonnull
    default public String getCommandString() {
        if (this.getCommandType() != Command.Type.SLASH) {
            return this.getName();
        }
        StringBuilder builder = new StringBuilder();
        builder.append("/").append(this.getName());
        if (this.getSubcommandGroup() != null) {
            builder.append(" ").append(this.getSubcommandGroup());
        }
        if (this.getSubcommandName() != null) {
            builder.append(" ").append(this.getSubcommandName());
        }
        block6: for (OptionMapping o : this.getOptions()) {
            builder.append(" ").append(o.getName()).append(": ");
            switch (o.getType()) {
                case CHANNEL: {
                    builder.append("#").append(o.getAsChannel().getName());
                    continue block6;
                }
                case USER: {
                    builder.append("@").append(o.getAsUser().getName());
                    continue block6;
                }
                case ROLE: {
                    builder.append("@").append(o.getAsRole().getName());
                    continue block6;
                }
                case MENTIONABLE: {
                    if (o.getAsMentionable() instanceof Role) {
                        builder.append("@").append(o.getAsRole().getName());
                        continue block6;
                    }
                    if (o.getAsMentionable() instanceof Member) {
                        builder.append("@").append(o.getAsUser().getName());
                        continue block6;
                    }
                    if (o.getAsMentionable() instanceof User) {
                        builder.append("@").append(o.getAsUser().getName());
                        continue block6;
                    }
                    builder.append("@").append(o.getAsMentionable().getIdLong());
                    continue block6;
                }
            }
            builder.append(o.getAsString());
        }
        return builder.toString();
    }

    public long getCommandIdLong();

    @Nonnull
    default public String getCommandId() {
        return Long.toUnsignedString(this.getCommandIdLong());
    }

    public boolean isGuildCommand();

    default public boolean isGlobalCommand() {
        return !this.isGuildCommand();
    }

    @Nonnull
    public List<OptionMapping> getOptions();

    @Nonnull
    default public List<OptionMapping> getOptionsByName(@Nonnull String name) {
        Checks.notNull(name, "Name");
        return this.getOptions().stream().filter(opt -> opt.getName().equals(name)).collect(Collectors.toList());
    }

    @Nonnull
    default public List<OptionMapping> getOptionsByType(@Nonnull OptionType type) {
        Checks.notNull((Object)type, "Type");
        return this.getOptions().stream().filter(it -> it.getType() == type).collect(Collectors.toList());
    }

    @Nullable
    default public OptionMapping getOption(@Nonnull String name) {
        List<OptionMapping> options = this.getOptionsByName(name);
        return options.isEmpty() ? null : options.get(0);
    }

    @Nullable
    default public <T> T getOption(@Nonnull String name, @Nonnull Function<? super OptionMapping, ? extends T> resolver) {
        return this.getOption(name, null, resolver);
    }

    default public <T> T getOption(@Nonnull String name, @Nullable T fallback, @Nonnull Function<? super OptionMapping, ? extends T> resolver) {
        Checks.notNull(resolver, "Resolver");
        OptionMapping mapping = this.getOption(name);
        if (mapping != null) {
            return resolver.apply(mapping);
        }
        return fallback;
    }

    default public <T> T getOption(@Nonnull String name, @Nullable Supplier<? extends T> fallback, @Nonnull Function<? super OptionMapping, ? extends T> resolver) {
        Checks.notNull(resolver, "Resolver");
        OptionMapping mapping = this.getOption(name);
        if (mapping != null) {
            return resolver.apply(mapping);
        }
        return fallback == null ? null : (T)fallback.get();
    }
}

