/*
 * Decompiled with CFR 0.152.
 */
package RASMI.rlogin.jda.jda.internal.entities.channel.mixin.attribute;

import RASMI.rlogin.jda.jda.api.JDA;
import RASMI.rlogin.jda.jda.api.Permission;
import RASMI.rlogin.jda.jda.api.entities.Webhook;
import RASMI.rlogin.jda.jda.api.entities.channel.attribute.IWebhookContainer;
import RASMI.rlogin.jda.jda.api.entities.channel.unions.IWebhookContainerUnion;
import RASMI.rlogin.jda.jda.api.requests.RestAction;
import RASMI.rlogin.jda.jda.api.requests.Route;
import RASMI.rlogin.jda.jda.api.requests.restaction.AuditableRestAction;
import RASMI.rlogin.jda.jda.api.requests.restaction.WebhookAction;
import RASMI.rlogin.jda.jda.api.utils.data.DataArray;
import RASMI.rlogin.jda.jda.internal.JDAImpl;
import RASMI.rlogin.jda.jda.internal.entities.EntityBuilder;
import RASMI.rlogin.jda.jda.internal.entities.WebhookImpl;
import RASMI.rlogin.jda.jda.internal.entities.channel.mixin.middleman.GuildChannelMixin;
import RASMI.rlogin.jda.jda.internal.requests.RestActionImpl;
import RASMI.rlogin.jda.jda.internal.requests.restaction.AuditableRestActionImpl;
import RASMI.rlogin.jda.jda.internal.requests.restaction.WebhookActionImpl;
import RASMI.rlogin.jda.jda.internal.utils.Checks;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public interface IWebhookContainerMixin<T extends IWebhookContainerMixin<T>>
extends IWebhookContainer,
IWebhookContainerUnion,
GuildChannelMixin<T> {
    @Override
    @Nonnull
    default public RestAction<List<Webhook>> retrieveWebhooks() {
        this.checkPermission(Permission.MANAGE_WEBHOOKS);
        Route.CompiledRoute route = Route.Channels.GET_WEBHOOKS.compile(this.getId());
        JDAImpl jda = (JDAImpl)this.getJDA();
        return new RestActionImpl<List<Webhook>>((JDA)jda, route, (response, request) -> {
            DataArray array = response.getArray();
            ArrayList<WebhookImpl> webhooks = new ArrayList<WebhookImpl>(array.length());
            EntityBuilder builder = jda.getEntityBuilder();
            for (int i = 0; i < array.length(); ++i) {
                try {
                    webhooks.add(builder.createWebhook(array.getObject(i)));
                    continue;
                }
                catch (UncheckedIOException | NullPointerException e) {
                    JDAImpl.LOG.error("Error while creating websocket from json", e);
                }
            }
            return Collections.unmodifiableList(webhooks);
        });
    }

    @Override
    @Nonnull
    default public WebhookAction createWebhook(@Nonnull String name) {
        Checks.notBlank(name, "Webhook name");
        name = name.trim();
        Checks.notEmpty(name, "Name");
        Checks.notLonger(name, 100, "Name");
        this.checkPermission(Permission.MANAGE_WEBHOOKS);
        return new WebhookActionImpl(this.getJDA(), this, name);
    }

    @Override
    @Nonnull
    default public AuditableRestAction<Void> deleteWebhookById(@Nonnull String id) {
        Checks.isSnowflake(id, "Webhook ID");
        this.checkPermission(Permission.MANAGE_WEBHOOKS);
        Route.CompiledRoute route = Route.Webhooks.DELETE_WEBHOOK.compile(id);
        return new AuditableRestActionImpl<Void>(this.getJDA(), route);
    }
}

