/*
 * Decompiled with CFR 0.152.
 */
package RASMI.rlogin.jda.jda.internal.entities.channel.mixin.middleman;

import RASMI.rlogin.jda.jda.api.Permission;
import RASMI.rlogin.jda.jda.api.entities.channel.attribute.IPermissionContainer;
import RASMI.rlogin.jda.jda.api.entities.channel.middleman.GuildChannel;
import RASMI.rlogin.jda.jda.api.entities.channel.unions.GuildChannelUnion;
import RASMI.rlogin.jda.jda.api.exceptions.InsufficientPermissionException;
import RASMI.rlogin.jda.jda.api.requests.Route;
import RASMI.rlogin.jda.jda.api.requests.restaction.AuditableRestAction;
import RASMI.rlogin.jda.jda.internal.entities.channel.mixin.ChannelMixin;
import RASMI.rlogin.jda.jda.internal.requests.restaction.AuditableRestActionImpl;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;

public interface GuildChannelMixin<T extends GuildChannelMixin<T>>
extends GuildChannel,
GuildChannelUnion,
ChannelMixin<T> {
    @Override
    @Nonnull
    @CheckReturnValue
    default public AuditableRestAction<Void> delete() {
        this.checkCanManage();
        Route.CompiledRoute route = Route.Channels.DELETE_CHANNEL.compile(this.getId());
        return new AuditableRestActionImpl<Void>(this.getJDA(), route);
    }

    default public boolean hasPermission(Permission permission) {
        IPermissionContainer permChannel = this.getPermissionContainer();
        return this.getGuild().getSelfMember().hasPermission((GuildChannel)permChannel, permission);
    }

    default public void checkPermission(Permission permission) {
        this.checkPermission(permission, null);
    }

    default public void checkPermission(Permission permission, String message) {
        if (!this.hasPermission(permission)) {
            if (message != null) {
                throw new InsufficientPermissionException(this, permission, message);
            }
            throw new InsufficientPermissionException(this, permission);
        }
    }

    default public void checkCanManage() {
        this.checkPermission(Permission.MANAGE_CHANNEL);
    }
}

