/*
 * Decompiled with CFR 0.152.
 */
package RASMI.rlogin.jda.jda.internal.entities.emoji;

import RASMI.rlogin.jda.jda.api.entities.emoji.CustomEmoji;
import RASMI.rlogin.jda.jda.api.entities.emoji.EmojiUnion;
import RASMI.rlogin.jda.jda.api.entities.emoji.UnicodeEmoji;
import RASMI.rlogin.jda.jda.api.utils.data.DataObject;
import RASMI.rlogin.jda.jda.internal.utils.EncodingUtil;
import RASMI.rlogin.jda.jda.internal.utils.EntityString;
import java.util.Objects;
import javax.annotation.Nonnull;

public class UnicodeEmojiImpl
implements UnicodeEmoji,
EmojiUnion {
    private final String name;

    public UnicodeEmojiImpl(String name) {
        this.name = name;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    @Nonnull
    public String getAsReactionCode() {
        return this.name;
    }

    @Override
    @Nonnull
    public String getAsCodepoints() {
        return EncodingUtil.encodeCodepoints(this.name);
    }

    @Override
    @Nonnull
    public DataObject toData() {
        return DataObject.empty().put("name", this.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof UnicodeEmoji)) {
            return false;
        }
        return this.name.equals(((UnicodeEmoji)obj).getName());
    }

    public String toString() {
        return new EntityString(this).addMetadata("codepoints", this.getAsCodepoints()).toString();
    }

    @Override
    @Nonnull
    public UnicodeEmoji asUnicode() {
        return this;
    }

    @Override
    @Nonnull
    public CustomEmoji asCustom() {
        throw new IllegalStateException("Cannot convert UnicodeEmoji into CustomEmoji!");
    }
}

