/*
 * Decompiled with CFR 0.152.
 */
package RASMI.rlogin.jda.jda.internal.interactions;

import RASMI.rlogin.jda.jda.api.JDA;
import RASMI.rlogin.jda.jda.api.entities.Guild;
import RASMI.rlogin.jda.jda.api.entities.Member;
import RASMI.rlogin.jda.jda.api.entities.User;
import RASMI.rlogin.jda.jda.api.entities.channel.Channel;
import RASMI.rlogin.jda.jda.api.entities.channel.ChannelType;
import RASMI.rlogin.jda.jda.api.entities.channel.concrete.PrivateChannel;
import RASMI.rlogin.jda.jda.api.entities.channel.middleman.GuildChannel;
import RASMI.rlogin.jda.jda.api.interactions.DiscordLocale;
import RASMI.rlogin.jda.jda.api.interactions.Interaction;
import RASMI.rlogin.jda.jda.api.utils.data.DataObject;
import RASMI.rlogin.jda.jda.internal.JDAImpl;
import RASMI.rlogin.jda.jda.internal.entities.GuildImpl;
import RASMI.rlogin.jda.jda.internal.entities.MemberImpl;
import RASMI.rlogin.jda.jda.internal.entities.UserImpl;
import RASMI.rlogin.jda.jda.internal.entities.channel.concrete.PrivateChannelImpl;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class InteractionImpl
implements Interaction {
    protected final long id;
    protected final long channelId;
    protected final int type;
    protected final String token;
    protected final Guild guild;
    protected final Member member;
    protected final User user;
    protected final Channel channel;
    protected final DiscordLocale userLocale;
    protected final JDAImpl api;
    private boolean isAck;

    public InteractionImpl(JDAImpl jda, DataObject data) {
        this.api = jda;
        this.id = data.getUnsignedLong("id");
        this.token = data.getString("token");
        this.type = data.getInt("type");
        this.guild = jda.getGuildById(data.getUnsignedLong("guild_id", 0L));
        this.channelId = data.getUnsignedLong("channel_id", 0L);
        this.userLocale = DiscordLocale.from(data.getString("locale", "en-US"));
        DataObject channelJson = data.getObject("channel");
        if (this.guild != null) {
            this.member = jda.getEntityBuilder().createMember((GuildImpl)this.guild, data.getObject("member"));
            jda.getEntityBuilder().updateMemberCache((MemberImpl)this.member);
            this.user = this.member.getUser();
            GuildChannel channel = this.guild.getGuildChannelById(channelJson.getUnsignedLong("id"));
            if (channel == null && ChannelType.fromId(channelJson.getInt("type")).isThread()) {
                channel = this.api.getEntityBuilder().createThreadChannel((GuildImpl)this.guild, channelJson, this.guild.getIdLong(), false);
            }
            if (channel == null) {
                throw new IllegalStateException("Failed to create channel instance for interaction! Channel Type: " + channelJson.getInt("type"));
            }
            this.channel = channel;
        } else {
            this.member = null;
            long channelId = channelJson.getUnsignedLong("id");
            ChannelType type = ChannelType.fromId(channelJson.getInt("type"));
            if (type != ChannelType.PRIVATE) {
                throw new IllegalArgumentException("Received interaction in unexpected channel type! Type " + (Object)((Object)type) + " is not supported yet!");
            }
            PrivateChannel channel = jda.getPrivateChannelById(channelId);
            if (channel == null) {
                channel = jda.getEntityBuilder().createPrivateChannel(DataObject.empty().put("id", channelId).put("recipient", data.getObject("user")));
            }
            this.channel = channel;
            User user = channel.getUser();
            if (user == null) {
                user = jda.getEntityBuilder().createUser(data.getObject("user"));
                ((PrivateChannelImpl)channel).setUser(user);
                ((UserImpl)user).setPrivateChannel(channel);
            }
            this.user = user;
        }
    }

    public synchronized void releaseHook(boolean success) {
    }

    public synchronized boolean ack() {
        boolean wasAck = this.isAck;
        this.isAck = true;
        return wasAck;
    }

    @Override
    public synchronized boolean isAcknowledged() {
        return this.isAck;
    }

    @Override
    public long getIdLong() {
        return this.id;
    }

    @Override
    public int getTypeRaw() {
        return this.type;
    }

    @Override
    @Nonnull
    public String getToken() {
        return this.token;
    }

    @Override
    @Nullable
    public Guild getGuild() {
        return this.guild;
    }

    @Override
    @Nullable
    public Channel getChannel() {
        return this.channel;
    }

    @Override
    public long getChannelIdLong() {
        return this.channelId;
    }

    @Override
    @Nonnull
    public DiscordLocale getUserLocale() {
        return this.userLocale;
    }

    @Override
    @Nonnull
    public User getUser() {
        return this.user;
    }

    @Override
    @Nullable
    public Member getMember() {
        return this.member;
    }

    @Override
    @Nonnull
    public JDA getJDA() {
        return this.api;
    }
}

