/*
 * Decompiled with CFR 0.152.
 */
package RASMI.rlogin.jda.jda.api.interactions;

import RASMI.rlogin.jda.jda.api.JDA;
import RASMI.rlogin.jda.jda.api.entities.Guild;
import RASMI.rlogin.jda.jda.api.entities.ISnowflake;
import RASMI.rlogin.jda.jda.api.entities.Member;
import RASMI.rlogin.jda.jda.api.entities.User;
import RASMI.rlogin.jda.jda.api.entities.channel.Channel;
import RASMI.rlogin.jda.jda.api.entities.channel.ChannelType;
import RASMI.rlogin.jda.jda.api.entities.channel.middleman.GuildChannel;
import RASMI.rlogin.jda.jda.api.entities.channel.middleman.MessageChannel;
import RASMI.rlogin.jda.jda.api.interactions.DiscordLocale;
import RASMI.rlogin.jda.jda.api.interactions.InteractionType;
import RASMI.rlogin.jda.jda.internal.utils.ChannelUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface Interaction
extends ISnowflake {
    public int getTypeRaw();

    @Nonnull
    default public InteractionType getType() {
        return InteractionType.fromKey(this.getTypeRaw());
    }

    @Nonnull
    public String getToken();

    @Nullable
    public Guild getGuild();

    default public boolean isFromGuild() {
        return this.getGuild() != null;
    }

    @Nonnull
    default public ChannelType getChannelType() {
        Channel channel = this.getChannel();
        return channel != null ? channel.getType() : ChannelType.UNKNOWN;
    }

    @Nonnull
    public User getUser();

    @Nullable
    public Member getMember();

    public boolean isAcknowledged();

    @Nullable
    public Channel getChannel();

    public long getChannelIdLong();

    @Nullable
    default public String getChannelId() {
        long id = this.getChannelIdLong();
        return id != 0L ? Long.toUnsignedString(this.getChannelIdLong()) : null;
    }

    @Nonnull
    default public GuildChannel getGuildChannel() {
        return ChannelUtil.safeChannelCast(this.getChannel(), GuildChannel.class);
    }

    @Nonnull
    default public MessageChannel getMessageChannel() {
        return ChannelUtil.safeChannelCast(this.getChannel(), MessageChannel.class);
    }

    @Nonnull
    public DiscordLocale getUserLocale();

    @Nonnull
    default public DiscordLocale getGuildLocale() {
        if (!this.isFromGuild()) {
            throw new IllegalStateException("This interaction did not happen in a guild");
        }
        return this.getGuild().getLocale();
    }

    @Nonnull
    public JDA getJDA();
}

