/*
 * Decompiled with CFR 0.152.
 */
package RASMI.rlogin.jda.jda.api.entities.channel.concrete;

import RASMI.rlogin.jda.jda.api.entities.Guild;
import RASMI.rlogin.jda.jda.api.entities.Member;
import RASMI.rlogin.jda.jda.api.entities.channel.attribute.ICategorizableChannel;
import RASMI.rlogin.jda.jda.api.entities.channel.attribute.ICopyableChannel;
import RASMI.rlogin.jda.jda.api.entities.channel.attribute.IMemberContainer;
import RASMI.rlogin.jda.jda.api.entities.channel.attribute.IPermissionContainer;
import RASMI.rlogin.jda.jda.api.entities.channel.attribute.IPositionableChannel;
import RASMI.rlogin.jda.jda.api.entities.channel.concrete.ForumChannel;
import RASMI.rlogin.jda.jda.api.entities.channel.concrete.MediaChannel;
import RASMI.rlogin.jda.jda.api.entities.channel.concrete.NewsChannel;
import RASMI.rlogin.jda.jda.api.entities.channel.concrete.StageChannel;
import RASMI.rlogin.jda.jda.api.entities.channel.concrete.TextChannel;
import RASMI.rlogin.jda.jda.api.entities.channel.concrete.VoiceChannel;
import RASMI.rlogin.jda.jda.api.entities.channel.middleman.GuildChannel;
import RASMI.rlogin.jda.jda.api.managers.channel.concrete.CategoryManager;
import RASMI.rlogin.jda.jda.api.requests.restaction.ChannelAction;
import RASMI.rlogin.jda.jda.api.requests.restaction.order.CategoryOrderAction;
import RASMI.rlogin.jda.jda.internal.utils.Helpers;
import java.util.Collection;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;

public interface Category
extends GuildChannel,
ICopyableChannel,
IPositionableChannel,
IPermissionContainer,
IMemberContainer {
    @Nonnull
    default public List<GuildChannel> getChannels() {
        return this.getGuild().getChannelCache().ofType(ICategorizableChannel.class).applyStream(stream -> stream.filter(it -> this.equals(it.getParentCategory())).sorted().collect(Helpers.toUnmodifiableList()));
    }

    @Nonnull
    default public List<TextChannel> getTextChannels() {
        return this.getGuild().getTextChannelCache().applyStream(stream -> stream.filter(channel -> this.equals(channel.getParentCategory())).sorted().collect(Helpers.toUnmodifiableList()));
    }

    @Nonnull
    default public List<NewsChannel> getNewsChannels() {
        return this.getGuild().getNewsChannelCache().applyStream(stream -> stream.filter(channel -> this.equals(channel.getParentCategory())).sorted().collect(Helpers.toUnmodifiableList()));
    }

    @Nonnull
    default public List<ForumChannel> getForumChannels() {
        return this.getGuild().getForumChannelCache().applyStream(stream -> stream.filter(channel -> this.equals(channel.getParentCategory())).sorted().collect(Helpers.toUnmodifiableList()));
    }

    @Nonnull
    default public List<MediaChannel> getMediaChannels() {
        return this.getGuild().getMediaChannelCache().applyStream(stream -> stream.filter(channel -> this.equals(channel.getParentCategory())).sorted().collect(Helpers.toUnmodifiableList()));
    }

    @Nonnull
    default public List<VoiceChannel> getVoiceChannels() {
        return this.getGuild().getVoiceChannelCache().applyStream(stream -> stream.filter(channel -> this.equals(channel.getParentCategory())).sorted().collect(Helpers.toUnmodifiableList()));
    }

    @Nonnull
    default public List<StageChannel> getStageChannels() {
        return this.getGuild().getStageChannelCache().applyStream(stream -> stream.filter(channel -> this.equals(channel.getParentCategory())).sorted().collect(Helpers.toUnmodifiableList()));
    }

    @Nonnull
    @CheckReturnValue
    public ChannelAction<TextChannel> createTextChannel(@Nonnull String var1);

    @Nonnull
    @CheckReturnValue
    public ChannelAction<NewsChannel> createNewsChannel(@Nonnull String var1);

    @Nonnull
    @CheckReturnValue
    public ChannelAction<VoiceChannel> createVoiceChannel(@Nonnull String var1);

    @Nonnull
    @CheckReturnValue
    public ChannelAction<StageChannel> createStageChannel(@Nonnull String var1);

    @Nonnull
    @CheckReturnValue
    public ChannelAction<ForumChannel> createForumChannel(@Nonnull String var1);

    @Nonnull
    @CheckReturnValue
    public ChannelAction<MediaChannel> createMediaChannel(@Nonnull String var1);

    @Nonnull
    @CheckReturnValue
    public CategoryOrderAction modifyTextChannelPositions();

    @Nonnull
    @CheckReturnValue
    public CategoryOrderAction modifyVoiceChannelPositions();

    @Override
    @Nonnull
    default public List<Member> getMembers() {
        return this.getChannels().stream().filter(IMemberContainer.class::isInstance).map(IMemberContainer.class::cast).map(IMemberContainer::getMembers).flatMap(Collection::stream).distinct().collect(Helpers.toUnmodifiableList());
    }

    @Nonnull
    public ChannelAction<Category> createCopy(@Nonnull Guild var1);

    @Nonnull
    public ChannelAction<Category> createCopy();

    @Override
    @Nonnull
    public CategoryManager getManager();
}

