/*
 * Decompiled with CFR 0.152.
 */
package RASMI.rlogin.jda.jda.api.events;

import RASMI.rlogin.jda.jda.api.JDA;
import RASMI.rlogin.jda.jda.api.events.GenericEvent;
import RASMI.rlogin.jda.jda.api.events.UpdateEvent;
import RASMI.rlogin.jda.jda.api.utils.data.DataObject;
import RASMI.rlogin.jda.jda.internal.JDAImpl;
import RASMI.rlogin.jda.jda.internal.handle.SocketHandler;
import RASMI.rlogin.jda.jda.internal.utils.EntityString;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class Event
implements GenericEvent {
    protected final JDA api;
    protected final long responseNumber;
    protected final DataObject rawData;

    public Event(@Nonnull JDA api, long responseNumber) {
        this.api = api;
        this.responseNumber = responseNumber;
        this.rawData = api instanceof JDAImpl && ((JDAImpl)api).isEventPassthrough() ? SocketHandler.CURRENT_EVENT.get() : null;
    }

    public Event(@Nonnull JDA api) {
        this(api, api.getResponseTotal());
    }

    @Override
    @Nonnull
    public JDA getJDA() {
        return this.api;
    }

    @Override
    public long getResponseNumber() {
        return this.responseNumber;
    }

    @Override
    @Nullable
    public DataObject getRawData() {
        if (this.api instanceof JDAImpl && !((JDAImpl)this.api).isEventPassthrough()) {
            throw new IllegalStateException("Event passthrough is not enabled, see JDABuilder#setEventPassthrough(boolean)");
        }
        return this.rawData;
    }

    public String toString() {
        if (this instanceof UpdateEvent) {
            UpdateEvent event = (UpdateEvent)((Object)this);
            return new EntityString(this).setType(event.getPropertyIdentifier()).addMetadata(null, event.getOldValue() + " -> " + event.getNewValue()).toString();
        }
        return new EntityString(this).toString();
    }
}

