/*
 * Decompiled with CFR 0.152.
 */
package RASMI.rlogin.jda.jda.api.interactions.callbacks;

import RASMI.rlogin.jda.jda.api.entities.MessageEmbed;
import RASMI.rlogin.jda.jda.api.interactions.callbacks.IDeferrableCallback;
import RASMI.rlogin.jda.jda.api.interactions.components.LayoutComponent;
import RASMI.rlogin.jda.jda.api.requests.restaction.interactions.ReplyCallbackAction;
import RASMI.rlogin.jda.jda.api.utils.FileUpload;
import RASMI.rlogin.jda.jda.api.utils.messages.MessageCreateData;
import RASMI.rlogin.jda.jda.internal.requests.restaction.interactions.ReplyCallbackActionImpl;
import RASMI.rlogin.jda.jda.internal.utils.Checks;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;

public interface IReplyCallback
extends IDeferrableCallback {
    @Nonnull
    @CheckReturnValue
    public ReplyCallbackAction deferReply();

    @Nonnull
    @CheckReturnValue
    default public ReplyCallbackAction deferReply(boolean ephemeral) {
        return this.deferReply().setEphemeral(ephemeral);
    }

    @Nonnull
    @CheckReturnValue
    default public ReplyCallbackAction reply(@Nonnull MessageCreateData message) {
        Checks.notNull(message, "Message");
        ReplyCallbackActionImpl action = (ReplyCallbackActionImpl)this.deferReply();
        return (ReplyCallbackAction)action.applyData(message);
    }

    @Nonnull
    @CheckReturnValue
    default public ReplyCallbackAction reply(@Nonnull String content) {
        Checks.notNull(content, "Content");
        return (ReplyCallbackAction)this.deferReply().setContent(content);
    }

    @Nonnull
    @CheckReturnValue
    default public ReplyCallbackAction replyEmbeds(@Nonnull Collection<? extends MessageEmbed> embeds) {
        return (ReplyCallbackAction)this.deferReply().addEmbeds(embeds);
    }

    @Nonnull
    @CheckReturnValue
    default public ReplyCallbackAction replyEmbeds(@Nonnull MessageEmbed embed, MessageEmbed ... embeds) {
        Checks.notNull(embed, "MessageEmbed");
        Checks.noneNull(embeds, "MessageEmbed");
        return (ReplyCallbackAction)((ReplyCallbackAction)this.deferReply().addEmbeds(embed)).addEmbeds(embeds);
    }

    @Nonnull
    @CheckReturnValue
    default public ReplyCallbackAction replyComponents(@Nonnull Collection<? extends LayoutComponent> components) {
        return (ReplyCallbackAction)this.deferReply().setComponents(components);
    }

    @Nonnull
    @CheckReturnValue
    default public ReplyCallbackAction replyComponents(@Nonnull LayoutComponent component, LayoutComponent ... other) {
        Checks.notNull(component, "LayoutComponents");
        Checks.noneNull(other, "LayoutComponents");
        ArrayList<LayoutComponent> layouts = new ArrayList<LayoutComponent>(1 + other.length);
        layouts.add(component);
        Collections.addAll(layouts, other);
        return this.replyComponents(layouts);
    }

    @Nonnull
    @CheckReturnValue
    default public ReplyCallbackAction replyFormat(@Nonnull String format, Object ... args2) {
        Checks.notNull(format, "Format String");
        return this.reply(String.format(format, args2));
    }

    @Nonnull
    @CheckReturnValue
    default public ReplyCallbackAction replyFiles(@Nonnull Collection<? extends FileUpload> files) {
        Checks.notEmpty(files, "File Collection");
        return (ReplyCallbackAction)this.deferReply().setFiles(files);
    }

    @Nonnull
    @CheckReturnValue
    default public ReplyCallbackAction replyFiles(FileUpload ... files) {
        Checks.notEmpty(files, "File Collection");
        Checks.noneNull(files, "FileUpload");
        return (ReplyCallbackAction)this.deferReply().setFiles(files);
    }
}

