/*
 * Decompiled with CFR 0.152.
 */
package RASMI.rlogin.jda.jda.api.utils.messages;

import RASMI.rlogin.jda.jda.api.entities.EmbedType;
import RASMI.rlogin.jda.jda.api.entities.Message;
import RASMI.rlogin.jda.jda.api.entities.MessageEmbed;
import RASMI.rlogin.jda.jda.api.interactions.components.ActionRow;
import RASMI.rlogin.jda.jda.api.interactions.components.ItemComponent;
import RASMI.rlogin.jda.jda.api.interactions.components.LayoutComponent;
import RASMI.rlogin.jda.jda.api.utils.FileUpload;
import RASMI.rlogin.jda.jda.api.utils.messages.MessageCreateData;
import RASMI.rlogin.jda.jda.api.utils.messages.MessageEditData;
import RASMI.rlogin.jda.jda.api.utils.messages.MessageRequest;
import RASMI.rlogin.jda.jda.internal.utils.Checks;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public interface MessageCreateRequest<R extends MessageCreateRequest<R>>
extends MessageRequest<R> {
    @Nonnull
    public R addContent(@Nonnull String var1);

    @Nonnull
    public R addEmbeds(@Nonnull Collection<? extends MessageEmbed> var1);

    @Nonnull
    default public R addEmbeds(MessageEmbed ... embeds) {
        return this.addEmbeds(Arrays.asList(embeds));
    }

    @Nonnull
    public R addComponents(@Nonnull Collection<? extends LayoutComponent> var1);

    @Nonnull
    default public R addComponents(LayoutComponent ... components) {
        return this.addComponents(Arrays.asList(components));
    }

    @Nonnull
    default public R addActionRow(@Nonnull Collection<? extends ItemComponent> components) {
        return this.addComponents(ActionRow.of(components));
    }

    @Nonnull
    default public R addActionRow(ItemComponent ... components) {
        return this.addComponents(ActionRow.of(components));
    }

    @Nonnull
    public R addFiles(@Nonnull Collection<? extends FileUpload> var1);

    @Nonnull
    default public R addFiles(FileUpload ... files) {
        return this.addFiles(Arrays.asList(files));
    }

    @Nonnull
    public List<FileUpload> getAttachments();

    @Nonnull
    public R setTTS(boolean var1);

    @Nonnull
    public R setSuppressedNotifications(boolean var1);

    @Nonnull
    default public R applyData(@Nonnull MessageCreateData data) {
        Checks.notNull(data, "MessageCreateData");
        List layoutComponents = data.getComponents().stream().map(LayoutComponent::createCopy).collect(Collectors.toList());
        return (R)((MessageCreateRequest)((MessageCreateRequest)((MessageCreateRequest)((MessageCreateRequest)((MessageCreateRequest)((MessageCreateRequest)((MessageCreateRequest)((MessageCreateRequest)((MessageCreateRequest)this.setContent(data.getContent())).setAllowedMentions(data.getAllowedMentions())).mentionUsers(data.getMentionedUsers())).mentionRoles(data.getMentionedRoles())).mentionRepliedUser(data.isMentionRepliedUser())).setEmbeds(data.getEmbeds())).setTTS(data.isTTS()).setSuppressEmbeds(data.isSuppressEmbeds())).setSuppressedNotifications(data.isSuppressedNotifications()).setComponents(layoutComponents)).setFiles(data.getFiles()));
    }

    @Override
    @Nonnull
    default public R applyMessage(@Nonnull Message message) {
        Checks.notNull(message, "Message");
        Checks.check(!message.getType().isSystem(), "Cannot copy a system message");
        List embeds = message.getEmbeds().stream().filter(e -> e.getType() == EmbedType.RICH).collect(Collectors.toList());
        return (R)((MessageCreateRequest)((MessageCreateRequest)((MessageCreateRequest)this.setContent(message.getContentRaw())).setEmbeds(embeds)).setTTS(message.isTTS()).setSuppressedNotifications(message.isSuppressedNotifications()).setComponents(message.getActionRows()));
    }

    @Nonnull
    default public R applyEditData(@Nonnull MessageEditData data) {
        Checks.notNull(data, "MessageEditData");
        if (data.isSet(1)) {
            this.setContent(data.getContent());
        }
        if (data.isSet(2)) {
            this.setEmbeds(data.getEmbeds());
        }
        if (data.isSet(4)) {
            List layoutComponents = data.getComponents().stream().map(LayoutComponent::createCopy).collect(Collectors.toList());
            this.setComponents(layoutComponents);
        }
        if (data.isSet(8)) {
            this.setFiles(data.getFiles());
        }
        if (data.isSet(16)) {
            this.setAllowedMentions(data.getAllowedMentions());
            this.mentionUsers(data.getMentionedUsers());
            this.mentionRoles(data.getMentionedRoles());
            this.mentionRepliedUser(data.isMentionRepliedUser());
        }
        return (R)this;
    }
}

