/*
 * Decompiled with CFR 0.152.
 */
package RASMI.rlogin.jda.jda.internal.handle;

import RASMI.rlogin.jda.jda.api.entities.channel.Channel;
import RASMI.rlogin.jda.jda.api.entities.channel.concrete.ThreadChannel;
import RASMI.rlogin.jda.jda.api.events.channel.ChannelDeleteEvent;
import RASMI.rlogin.jda.jda.api.utils.data.DataObject;
import RASMI.rlogin.jda.jda.internal.JDAImpl;
import RASMI.rlogin.jda.jda.internal.entities.GuildImpl;
import RASMI.rlogin.jda.jda.internal.handle.EventCache;
import RASMI.rlogin.jda.jda.internal.handle.SocketHandler;
import RASMI.rlogin.jda.jda.internal.requests.WebSocketClient;
import RASMI.rlogin.jda.jda.internal.utils.cache.ChannelCacheViewImpl;

public class ThreadDeleteHandler
extends SocketHandler {
    public ThreadDeleteHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(DataObject content) {
        long guildId = content.getLong("guild_id");
        if (this.getJDA().getGuildSetupController().isLocked(guildId)) {
            return guildId;
        }
        GuildImpl guild = (GuildImpl)this.getJDA().getGuildById(guildId);
        long threadId = content.getLong("id");
        ChannelCacheViewImpl<Channel> channelsView = this.getJDA().getChannelsView();
        ThreadChannel thread2 = (ThreadChannel)((ChannelCacheViewImpl.FilteredCacheView)channelsView.ofType(ThreadChannel.class)).getElementById(threadId);
        if (thread2 == null || guild == null) {
            WebSocketClient.LOG.debug("THREAD_DELETE attempted to delete a thread that is not yet cached. JSON: {}", (Object)content);
            return null;
        }
        channelsView.remove(thread2.getType(), threadId);
        guild.getChannelView().remove(thread2);
        this.getJDA().handleEvent(new ChannelDeleteEvent(this.getJDA(), this.responseNumber, thread2));
        this.getJDA().getEventCache().clear(EventCache.Type.CHANNEL, threadId);
        return null;
    }
}

