/*
 * Decompiled with CFR 0.152.
 */
package RASMI.rlogin;

import RASMI.rlogin.gson.JsonObject;
import RASMI.rlogin.gson.JsonParser;
import RASMI.rlogin.jda.jda.api.JDA;
import RASMI.rlogin.jda.jda.api.JDABuilder;
import RASMI.rlogin.jda.jda.api.events.interaction.component.ButtonInteractionEvent;
import RASMI.rlogin.jda.jda.api.events.message.MessageReceivedEvent;
import RASMI.rlogin.jda.jda.api.hooks.ListenerAdapter;
import RASMI.rlogin.jda.jda.api.interactions.components.buttons.Button;
import RASMI.rlogin.jda.jda.api.requests.restaction.MessageCreateAction;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Rlogin
extends JavaPlugin
implements Listener {
    private static final String PERMISSION_ADMIN = "rlogin.admin";
    private static final String PASSWORDS_PATH = "passwords";
    private static final String IPS_PATH = "ips";
    private static final String TWO_FA_PATH = "2fa";
    private static final Set<String> HIDDEN_COMMANDS = Set.of("login", "l", "register", "reg", "changepass", "add2fa", "remove2fa");
    private static final Set<String> ALLOWED_COMMANDS = Set.of("login", "l", "register", "reg", "changepass", "add2fa", "remove2fa");
    private final Map<String, Boolean> loggedInPlayers = new HashMap<String, Boolean>();
    private final Map<String, String> pending2FACodes = new ConcurrentHashMap<String, String>();
    private final Map<String, String> pendingRemove2FACodes = new ConcurrentHashMap<String, String>();
    private final Map<String, String> pendingLogins = new ConcurrentHashMap<String, String>();
    private final File passwordsFile = new File(this.getDataFolder(), "passwords.yml");
    private final FileConfiguration passwordsConfig = YamlConfiguration.loadConfiguration((File)this.passwordsFile);
    private final File ipFile = new File(this.getDataFolder(), "ips.yml");
    private final FileConfiguration ipConfig = YamlConfiguration.loadConfiguration((File)this.ipFile);
    private final File twoFaFile = new File(this.getDataFolder(), "2fa.yml");
    private final FileConfiguration twoFaConfig = YamlConfiguration.loadConfiguration((File)this.twoFaFile);
    private JDA jda;

    public void onEnable() {
        this.saveDefaultConfig();
        this.setupDefaultMessages();
        this.initializeConfigFile(this.passwordsFile);
        this.initializeConfigFile(this.ipFile);
        this.initializeConfigFile(this.twoFaFile);
        if (this.getConfig().getBoolean("discord.enabled", false)) {
            try {
                this.jda = JDABuilder.createDefault(this.getConfig().getString("discord.bot_token")).addEventListeners(new DiscordListener(this)).build();
                this.jda.awaitReady();
                this.getLogger().info("Discord-\u0431\u043e\u0442 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u043d.");
            }
            catch (Exception e) {
                this.getLogger().warning("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u0442\u044c Discord-\u0431\u043e\u0442\u0430: " + e.getMessage() + ". 2FA \u0431\u0443\u0434\u0435\u0442 \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u0430.");
                this.jda = null;
            }
        } else {
            this.getLogger().info("Discord-\u0431\u043e\u0442 \u043e\u0442\u043a\u043b\u044e\u0447\u0451\u043d \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438. 2FA \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430.");
        }
        this.registerCommands("login", "register", "l", "reg", "changepass", "rlchangepass", "rlogin", "add2fa", "remove2fa");
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        new BukkitRunnable(){

            public void run() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (Rlogin.this.isLoggedIn(player)) continue;
                    String playerName = player.getName();
                    String message = Rlogin.this.getPasswords().containsKey(playerName) ? (Rlogin.this.getConfig().getBoolean("discord.enabled", false) && Rlogin.this.has2FA(playerName) && Rlogin.this.jda != null && Rlogin.this.pendingLogins.containsValue(playerName) ? Rlogin.this.getConfig().getString("messages.login_2fa_pending") : Rlogin.this.getConfig().getString("messages.login_message")) : Rlogin.this.getConfig().getString("messages.register_message");
                    player.sendMessage(Rlogin.this.translateColorCodes(message));
                }
            }
        }.runTaskTimer((Plugin)this, 0L, 100L);
    }

    public void onDisable() {
        if (this.jda != null) {
            this.jda.shutdown();
        }
    }

    private void initializeConfigFile(File file) {
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                this.getLogger().severe("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u0444\u0430\u0439\u043b " + file.getName() + ": " + e.getMessage());
            }
        }
    }

    private void registerCommands(String ... commands) {
        for (String cmd : commands) {
            this.getCommand(cmd).setExecutor((CommandExecutor)this);
        }
    }

    private void setupDefaultMessages() {
        FileConfiguration config = this.getConfig();
        config.addDefault("auto_login.enabled", (Object)true);
        config.addDefault("discord.enabled", (Object)false);
        config.addDefault("discord.bot_token", (Object)"YOUR_BOT_TOKEN_HERE");
        config.addDefault("messages.register_message", (Object)"&c\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 /register \u0434\u043b\u044f \u043d\u0430\u0447\u0430\u043b\u0430 \u0438\u0433\u0440\u044b.");
        config.addDefault("messages.login_message", (Object)"&c\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 /login \u0434\u043b\u044f \u0432\u0445\u043e\u0434\u0430.");
        config.addDefault("messages.register_usage", (Object)"&c\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435: /register <\u043f\u0430\u0440\u043e\u043b\u044c> <\u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435_\u043f\u0430\u0440\u043e\u043b\u044f>");
        config.addDefault("messages.login_usage", (Object)"&c\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435: /login <\u043f\u0430\u0440\u043e\u043b\u044c>");
        config.addDefault("messages.already_registered", (Object)"&c\u0412\u044b \u0443\u0436\u0435 \u0437\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u043d\u044b. \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 /login <\u043f\u0430\u0440\u043e\u043b\u044c>.");
        config.addDefault("messages.passwords_do_not_match", (Object)"&c\u041f\u0430\u0440\u043e\u043b\u0438 \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u044e\u0442. \u041f\u043e\u043f\u0440\u043e\u0431\u0443\u0439\u0442\u0435 \u0441\u043d\u043e\u0432\u0430.");
        config.addDefault("messages.registration_successful", (Object)"&a\u0412\u044b \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0437\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u043b\u0438\u0441\u044c. \u0412\u043e\u0439\u0434\u0438\u0442\u0435 \u0441 \u043f\u043e\u043c\u043e\u0449\u044c\u044e /login <\u043f\u0430\u0440\u043e\u043b\u044c>.");
        config.addDefault("messages.not_registered", (Object)"&c\u0412\u044b \u043d\u0435 \u0437\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u043d\u044b. \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 /register <\u043f\u0430\u0440\u043e\u043b\u044c> <\u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435_\u043f\u0430\u0440\u043e\u043b\u044f>.");
        config.addDefault("messages.incorrect_password", (Object)"&c\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043f\u0430\u0440\u043e\u043b\u044c.");
        config.addDefault("messages.login_successful", (Object)"&a\u0412\u044b \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0432\u043e\u0448\u043b\u0438.");
        config.addDefault("messages.auto_login", (Object)"&a\u0412\u044b \u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438 \u0432\u043e\u0448\u043b\u0438.");
        config.addDefault("messages.command_blocked", (Object)"&c\u0412\u044b \u0434\u043e\u043b\u0436\u043d\u044b \u0432\u043e\u0439\u0442\u0438, \u0447\u0442\u043e\u0431\u044b \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u043a\u043e\u043c\u0430\u043d\u0434\u044b, \u043a\u0440\u043e\u043c\u0435 /login, /l, /register, /reg, /changepass, /add2fa, /remove2fa.");
        config.addDefault("messages.changepass_usage", (Object)"&c\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435: /changepass <\u0441\u0442\u0430\u0440\u044b\u0439_\u043f\u0430\u0440\u043e\u043b\u044c> <\u043d\u043e\u0432\u044b\u0439_\u043f\u0430\u0440\u043e\u043b\u044c>");
        config.addDefault("messages.changepass_successful", (Object)"&a\u041f\u0430\u0440\u043e\u043b\u044c \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0438\u0437\u043c\u0435\u043d\u0451\u043d.");
        config.addDefault("messages.rlchangepass_usage", (Object)"&c\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435: /rlchangepass <\u0438\u0433\u0440\u043e\u043a> <\u043d\u043e\u0432\u044b\u0439_\u043f\u0430\u0440\u043e\u043b\u044c>");
        config.addDefault("messages.rlchangepass_no_permission", (Object)"&c\u0423 \u0432\u0430\u0441 \u043d\u0435\u0442 \u043f\u0440\u0430\u0432 \u043d\u0430 \u044d\u0442\u0443 \u043a\u043e\u043c\u0430\u043d\u0434\u0443.");
        config.addDefault("messages.rlchangepass_player_not_found", (Object)"&c\u0418\u0433\u0440\u043e\u043a \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0438\u043b\u0438 \u043d\u0435 \u0437\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u043d.");
        config.addDefault("messages.rlchangepass_successful", (Object)"&a\u041f\u0430\u0440\u043e\u043b\u044c \u0434\u043b\u044f {0} \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0438\u0437\u043c\u0435\u043d\u0451\u043d.");
        config.addDefault("messages.rlogin_usage", (Object)"&c\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435: /rlogin reload");
        config.addDefault("messages.rlogin_no_permission", (Object)"&c\u0423 \u0432\u0430\u0441 \u043d\u0435\u0442 \u043f\u0440\u0430\u0432 \u043d\u0430 \u044d\u0442\u0443 \u043a\u043e\u043c\u0430\u043d\u0434\u0443.");
        config.addDefault("messages.rlogin_reload_successful", (Object)"&a\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f Rlogin \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u0430.");
        config.addDefault("messages.rlogin_reload_failed", (Object)"&c\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044e Rlogin.");
        config.addDefault("messages.2fa_disabled", (Object)"&c\u0414\u0432\u0443\u0445\u0444\u0430\u043a\u0442\u043e\u0440\u043d\u0430\u044f \u0430\u0443\u0442\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u044f \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u0430 \u043d\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u0435.");
        config.addDefault("messages.add2fa_usage", (Object)"&c\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435: /add2fa");
        config.addDefault("messages.add2fa_code_sent", (Object)"&a\u0412\u0430\u043c \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d \u043a\u043e\u0434 2FA. \u041e\u0442\u043f\u0440\u0430\u0432\u044c\u0442\u0435 \u0435\u0433\u043e \u0431\u043e\u0442\u0443 \u0432 Discord: %code%");
        config.addDefault("messages.add2fa_already_enabled", (Object)"&c2FA \u0443\u0436\u0435 \u0432\u043a\u043b\u044e\u0447\u0435\u043d\u0430 \u0434\u043b\u044f \u0432\u0430\u0448\u0435\u0433\u043e \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430.");
        config.addDefault("messages.add2fa_successful", (Object)"&a2FA \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0432\u043a\u043b\u044e\u0447\u0435\u043d\u0430.");
        config.addDefault("messages.remove2fa_usage", (Object)"&c\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435: /remove2fa <\u043a\u043e\u0434>");
        config.addDefault("messages.remove2fa_not_enabled", (Object)"&c2FA \u043d\u0435 \u0432\u043a\u043b\u044e\u0447\u0435\u043d\u0430 \u0434\u043b\u044f \u0432\u0430\u0448\u0435\u0433\u043e \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430.");
        config.addDefault("messages.remove2fa_code_sent", (Object)"&a\u041e\u0442\u043f\u0440\u0430\u0432\u044c\u0442\u0435 /remove2fa \u0432 Discord-\u0431\u043e\u0442, \u0447\u0442\u043e\u0431\u044b \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u043a\u043e\u0434, \u0437\u0430\u0442\u0435\u043c \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 /remove2fa <\u043a\u043e\u0434> \u0432 \u0438\u0433\u0440\u0435.");
        config.addDefault("messages.remove2fa_invalid_code", (Object)"&c\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0438\u043b\u0438 \u0438\u0441\u0442\u0451\u043a\u0448\u0438\u0439 \u043a\u043e\u0434 \u0434\u043b\u044f \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f 2FA.");
        config.addDefault("messages.remove2fa_successful", (Object)"&a2FA \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u0430.");
        config.addDefault("messages.discord_code_invalid", (Object)"&c\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0438\u043b\u0438 \u0438\u0441\u0442\u0451\u043a\u0448\u0438\u0439 \u043a\u043e\u0434 2FA.");
        config.addDefault("messages.discord_remove2fa_code_sent", (Object)"\u041a\u043e\u0434 \u0434\u043b\u044f \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f 2FA \u0434\u043b\u044f %player%: %code%. \u0412\u0432\u0435\u0434\u0438\u0442\u0435 /remove2fa <\u043a\u043e\u0434> \u0432 \u0438\u0433\u0440\u0435.");
        config.addDefault("messages.discord_login_request", (Object)"\u0417\u0430\u0444\u0438\u043a\u0441\u0438\u0440\u043e\u0432\u0430\u043d \u0432\u0445\u043e\u0434 \u043d\u0430 \u0432\u0430\u0448 \u0430\u043a\u043a\u0430\u0443\u043d\u0442 %player% \u0441 IP %ip% (%country_flag%). \u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0434\u0438\u0442\u0435 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0435:");
        config.addDefault("messages.login_2fa_pending", (Object)"&c\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0434\u0438\u0442\u0435 \u0432\u0445\u043e\u0434 \u0447\u0435\u0440\u0435\u0437 2FA \u0432 Discord.");
        config.addDefault("messages.login_2fa_rejected", (Object)"&c\u0412\u0445\u043e\u0434 \u043e\u0442\u043a\u043b\u043e\u043d\u0451\u043d \u0447\u0435\u0440\u0435\u0437 Discord.");
        config.options().copyDefaults(true);
        this.saveConfig();
    }

    private String translateColorCodes(String message) {
        return message != null ? ChatColor.translateAlternateColorCodes((char)'&', (String)message) : "";
    }

    private String generateSalt() {
        byte[] salt = new byte[16];
        new SecureRandom().nextBytes(salt);
        return Base64.getEncoder().encodeToString(salt);
    }

    private String hashPassword(String password, String salt) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(salt.getBytes(StandardCharsets.UTF_8));
            byte[] hash = md.digest(password.getBytes(StandardCharsets.UTF_8));
            return Base64.getEncoder().encodeToString(hash);
        }
        catch (NoSuchAlgorithmException e) {
            this.getLogger().severe("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0445\u0435\u0448\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u0430\u0440\u043e\u043b\u044c: " + e.getMessage());
            return null;
        }
    }

    private String generate2FACode() {
        return UUID.randomUUID().toString().substring(0, 8);
    }

    private String getCountryFlagFromIP(String ip) {
        try {
            HttpClient client = HttpClient.newHttpClient();
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create("http://ip-api.com/json/" + ip)).build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            JsonObject json = JsonParser.parseString(response.body()).getAsJsonObject();
            if (json.has("countryCode")) {
                String countryCode = json.get("countryCode").getAsString().toUpperCase();
                return countryCode.chars().mapToObj(ch -> String.valueOf(Character.toChars(127462 + (ch - 65)))).collect(Collectors.joining());
            }
            return "\ud83c\udff3\ufe0f";
        }
        catch (Exception e) {
            this.getLogger().warning("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0444\u043b\u0430\u0433 \u0441\u0442\u0440\u0430\u043d\u044b \u043f\u043e IP " + ip + ": " + e.getMessage());
            return "\ud83c\udff3\ufe0f";
        }
    }

    private void reloadConfigs() {
        this.reloadConfig();
        if (this.getConfig().getBoolean("discord.enabled", false) && this.jda == null) {
            try {
                this.jda = JDABuilder.createDefault(this.getConfig().getString("discord.bot_token")).addEventListeners(new DiscordListener(this)).build();
                this.jda.awaitReady();
                this.getLogger().info("Discord-\u0431\u043e\u0442 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u0435\u0440\u0435\u0437\u0430\u043f\u0443\u0449\u0435\u043d \u043f\u043e\u0441\u043b\u0435 \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u043a\u043e\u043d\u0444\u0438\u0433\u0430.");
            }
            catch (Exception e) {
                this.getLogger().warning("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0435\u0440\u0435\u0437\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u044c Discord-\u0431\u043e\u0442\u0430: " + e.getMessage());
                this.jda = null;
            }
        } else if (!this.getConfig().getBoolean("discord.enabled", false) && this.jda != null) {
            this.jda.shutdown();
            this.jda = null;
            this.getLogger().info("Discord-\u0431\u043e\u0442 \u043e\u0442\u043a\u043b\u044e\u0447\u0451\u043d \u043f\u043e\u0441\u043b\u0435 \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u043a\u043e\u043d\u0444\u0438\u0433\u0430.");
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args2) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (label.equalsIgnoreCase("login") || label.equalsIgnoreCase("l")) {
                String salt;
                String playerName;
                if (args2.length != 1) {
                    player.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.login_usage")));
                    return false;
                }
                Map<String, String> passwords = this.getPasswords();
                if (!passwords.containsKey(playerName = player.getName())) {
                    player.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.not_registered")));
                    return false;
                }
                storedData = passwords.get(playerName).split(":");
                String storedHash = storedData[0];
                String string = salt = storedData.length > 1 ? storedData[1] : "";
                if (storedHash.equals(this.hashPassword(args2[0], salt))) {
                    String ip = this.getPlayerIP(player);
                    if (this.getConfig().getBoolean("discord.enabled", false) && this.has2FA(playerName) && this.jda != null && !this.getConfig().getBoolean("auto_login.enabled", true)) {
                        String countryFlag = this.getCountryFlagFromIP(ip);
                        this.send2FARequest(player, ip, countryFlag);
                        player.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.login_2fa_pending")));
                    } else if (this.getConfig().getBoolean("discord.enabled", false) && this.has2FA(playerName) && this.jda != null && !this.isIPValid(player, ip)) {
                        String countryFlag = this.getCountryFlagFromIP(ip);
                        this.send2FARequest(player, ip, countryFlag);
                        player.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.login_2fa_pending")));
                    } else {
                        this.setLoggedIn(player, true);
                        player.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.login_successful")));
                        if (ip != null) {
                            this.setIP(player, ip);
                        }
                    }
                } else {
                    player.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.incorrect_password")));
                }
            } else if (label.equalsIgnoreCase("register") || label.equalsIgnoreCase("reg")) {
                if (args2.length != 2) {
                    player.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.register_usage")));
                    return false;
                }
                playerName = player.getName();
                if (this.getPasswords().containsKey(playerName)) {
                    player.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.already_registered")));
                    return false;
                }
                if (!args2[0].equals(args2[1])) {
                    player.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.passwords_do_not_match")));
                    return false;
                }
                this.setPassword(player, args2[0]);
                player.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.registration_successful")));
            } else if (label.equalsIgnoreCase("changepass")) {
                String salt;
                if (args2.length != 2) {
                    player.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.changepass_usage")));
                    return false;
                }
                playerName = player.getName();
                Map<String, String> passwords = this.getPasswords();
                if (!passwords.containsKey(playerName)) {
                    player.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.not_registered")));
                    return false;
                }
                storedData = passwords.get(playerName).split(":");
                String storedHash = storedData[0];
                String string = salt = storedData.length > 1 ? storedData[1] : "";
                if (!storedHash.equals(this.hashPassword(args2[0], salt))) {
                    player.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.incorrect_password")));
                    return false;
                }
                this.setPassword(player, args2[1]);
                player.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.changepass_successful")));
            } else if (label.equalsIgnoreCase("add2fa")) {
                if (!this.getConfig().getBoolean("discord.enabled", false) || this.jda == null) {
                    player.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.2fa_disabled")));
                    return false;
                }
                if (args2.length != 0) {
                    player.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.add2fa_usage")));
                    return false;
                }
                playerName = player.getName();
                if (this.has2FA(playerName)) {
                    player.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.add2fa_already_enabled")));
                    return false;
                }
                code = this.generate2FACode();
                this.pending2FACodes.put(playerName, code);
                player.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.add2fa_code_sent").replace("%code%", code)));
            } else if (label.equalsIgnoreCase("remove2fa")) {
                if (!this.getConfig().getBoolean("discord.enabled", false) || this.jda == null) {
                    player.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.2fa_disabled")));
                    return false;
                }
                playerName = player.getName();
                if (!this.has2FA(playerName)) {
                    player.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.remove2fa_not_enabled")));
                    return false;
                }
                if (args2.length != 1) {
                    player.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.remove2fa_usage")));
                    player.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.remove2fa_code_sent")));
                    return false;
                }
                code = args2[0];
                if (code.equals(this.pendingRemove2FACodes.get(playerName))) {
                    this.pendingRemove2FACodes.remove(playerName);
                    this.remove2FA(playerName);
                    player.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.remove2fa_successful")));
                } else {
                    player.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.remove2fa_invalid_code")));
                }
            }
        }
        if (label.equalsIgnoreCase("rlchangepass")) {
            if (!sender.hasPermission(PERMISSION_ADMIN)) {
                sender.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.rlchangepass_no_permission")));
                return false;
            }
            if (args2.length != 2) {
                sender.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.rlchangepass_usage")));
                return false;
            }
            String targetPlayerName = args2[0];
            if (!this.getPasswords().containsKey(targetPlayerName)) {
                sender.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.rlchangepass_player_not_found")));
                return false;
            }
            Player targetPlayer = Bukkit.getPlayerExact((String)targetPlayerName);
            if (targetPlayer != null) {
                this.setPassword(targetPlayer, args2[1]);
            } else {
                String salt = this.generateSalt();
                String hashedPassword = this.hashPassword(args2[1], salt);
                if (hashedPassword != null) {
                    this.passwordsConfig.set("passwords." + targetPlayerName, (Object)(hashedPassword + ":" + salt));
                    this.savePasswordsConfig();
                }
            }
            sender.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.rlchangepass_successful").replace("{0}", targetPlayerName)));
        } else if (label.equalsIgnoreCase("rlogin")) {
            if (!sender.hasPermission(PERMISSION_ADMIN)) {
                sender.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.rlogin_no_permission")));
                return false;
            }
            if (args2.length != 1 || !args2[0].equalsIgnoreCase("reload")) {
                sender.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.rlogin_usage")));
                return false;
            }
            try {
                this.reloadConfigs();
                sender.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.rlogin_reload_successful")));
            }
            catch (Exception e) {
                sender.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.rlogin_reload_failed")));
                this.getLogger().severe("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u043a\u043e\u043d\u0444\u0438\u0433: " + e.getMessage());
            }
        }
        return true;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        String ip = this.getPlayerIP(player);
        String playerName = player.getName();
        if (this.getConfig().getBoolean("auto_login.enabled", true) && ip != null && this.isIPValid(player, ip)) {
            this.setLoggedIn(player, true);
            player.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.auto_login")));
            this.setIP(player, ip);
        } else {
            String message = this.getPasswords().containsKey(playerName) ? this.getConfig().getString("messages.login_message") : this.getConfig().getString("messages.register_message");
            player.sendMessage(this.translateColorCodes(message));
            this.setLoggedIn(player, false);
        }
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        if (!this.isLoggedIn(event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (!this.isLoggedIn(event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        if (!this.isLoggedIn(event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerDamage(EntityDamageEvent event) {
        Player player;
        Entity entity = event.getEntity();
        if (entity instanceof Player && !this.isLoggedIn(player = (Player)entity)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        if (!this.isLoggedIn(event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerCommand(PlayerCommandPreprocessEvent event) {
        Player player = event.getPlayer();
        String command = event.getMessage().toLowerCase().split(" ")[0].substring(1);
        if (HIDDEN_COMMANDS.contains(command)) {
            event.setCancelled(true);
            String[] args2 = event.getMessage().split(" ");
            String cmdLabel = args2[0].substring(1);
            CharSequence[] cmdArgs = args2.length > 1 ? Arrays.copyOfRange(args2, 1, args2.length) : new String[]{};
            Bukkit.dispatchCommand((CommandSender)player, (String)(cmdLabel + " " + String.join((CharSequence)" ", cmdArgs)));
            return;
        }
        if (!this.isLoggedIn(player) && !ALLOWED_COMMANDS.contains(command)) {
            event.setCancelled(true);
            player.sendMessage(this.translateColorCodes(this.getConfig().getString("messages.command_blocked")));
        }
    }

    public boolean isLoggedIn(Player player) {
        return this.loggedInPlayers.getOrDefault(player.getName(), false);
    }

    public void setLoggedIn(Player player, boolean loggedIn) {
        this.loggedInPlayers.put(player.getName(), loggedIn);
    }

    public Map<String, String> getPasswords() {
        HashMap<String, String> passwords = new HashMap<String, String>();
        if (this.passwordsConfig.contains(PASSWORDS_PATH)) {
            for (String key : this.passwordsConfig.getConfigurationSection(PASSWORDS_PATH).getKeys(false)) {
                passwords.put(key, this.passwordsConfig.getString("passwords." + key));
            }
        }
        return passwords;
    }

    public void setPassword(Player player, String password) {
        String salt = this.generateSalt();
        String hashedPassword = this.hashPassword(password, salt);
        if (hashedPassword != null) {
            this.passwordsConfig.set("passwords." + player.getName(), (Object)(hashedPassword + ":" + salt));
            this.savePasswordsConfig();
        }
    }

    private void savePasswordsConfig() {
        try {
            this.passwordsConfig.save(this.passwordsFile);
        }
        catch (IOException e) {
            this.getLogger().severe("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c passwords.yml: " + e.getMessage());
        }
    }

    public boolean isIPValid(Player player, String ip) {
        String lastLoginString = this.ipConfig.getString("ips." + player.getName() + "." + ip);
        if (lastLoginString == null) {
            return false;
        }
        try {
            long lastLogin = Long.parseLong(lastLoginString);
            long now = System.currentTimeMillis();
            return now - lastLogin < 172800000L;
        }
        catch (NumberFormatException e) {
            this.getLogger().warning("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439 \u0448\u0442\u0430\u043c\u043f \u0432 ips.yml \u0434\u043b\u044f " + player.getName() + ": " + lastLoginString);
            return false;
        }
    }

    public void setIP(Player player, String ip) {
        this.ipConfig.set("ips." + player.getName() + "." + ip, (Object)String.valueOf(System.currentTimeMillis()));
        this.saveIPConfig();
    }

    private void saveIPConfig() {
        try {
            this.ipConfig.save(this.ipFile);
        }
        catch (IOException e) {
            this.getLogger().severe("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c ips.yml: " + e.getMessage());
        }
    }

    private String getPlayerIP(Player player) {
        try {
            return player.getAddress().getAddress().getHostAddress();
        }
        catch (NullPointerException e) {
            this.getLogger().warning("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c IP \u0434\u043b\u044f " + player.getName());
            return null;
        }
    }

    public boolean has2FA(String playerName) {
        return this.twoFaConfig.contains("2fa." + playerName);
    }

    public void enable2FA(String playerName, String discordId) {
        this.twoFaConfig.set("2fa." + playerName, (Object)discordId);
        try {
            this.twoFaConfig.save(this.twoFaFile);
        }
        catch (IOException e) {
            this.getLogger().severe("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c 2fa.yml: " + e.getMessage());
        }
    }

    public void remove2FA(String playerName) {
        this.twoFaConfig.set("2fa." + playerName, null);
        try {
            this.twoFaConfig.save(this.twoFaFile);
        }
        catch (IOException e) {
            this.getLogger().severe("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c 2fa.yml: " + e.getMessage());
        }
    }

    public String getDiscordId(String playerName) {
        return this.twoFaConfig.getString("2fa." + playerName);
    }

    public void send2FARequest(Player player, String ip, String countryFlag) {
        String playerName = player.getName();
        String discordId = this.getDiscordId(playerName);
        if (discordId == null) {
            return;
        }
        String loginId = UUID.randomUUID().toString();
        this.pendingLogins.put(loginId, playerName);
        String message = this.getConfig().getString("messages.discord_login_request").replace("%player%", playerName).replace("%ip%", ip).replace("%country_flag%", countryFlag);
        this.jda.retrieveUserById(discordId).queue(user -> user.openPrivateChannel().queue(channel -> ((MessageCreateAction)channel.sendMessage(message).setActionRow(Button.success("accept-" + loginId, "\u041f\u0440\u0438\u043d\u044f\u0442\u044c"), Button.danger("reject-" + loginId, "\u041e\u0442\u043a\u043b\u043e\u043d\u0438\u0442\u044c"))).queue()));
    }

    public class DiscordListener
    extends ListenerAdapter {
        private final Rlogin plugin;

        public DiscordListener(Rlogin plugin) {
            this.plugin = plugin;
        }

        @Override
        public void onButtonInteraction(ButtonInteractionEvent event) {
            String buttonId = event.getButton().getId();
            if (buttonId.startsWith("accept-") || buttonId.startsWith("reject-")) {
                String loginId = buttonId.substring(buttonId.indexOf("-") + 1);
                String playerName = Rlogin.this.pendingLogins.remove(loginId);
                if (playerName == null) {
                    event.reply("\u042d\u0442\u043e\u0442 \u0437\u0430\u043f\u0440\u043e\u0441 \u0443\u0441\u0442\u0430\u0440\u0435\u043b.").setEphemeral(true).queue();
                    return;
                }
                Player player = Bukkit.getPlayerExact((String)playerName);
                if (player == null) {
                    event.reply("\u0418\u0433\u0440\u043e\u043a \u043d\u0435 \u0432 \u0441\u0435\u0442\u0438.").setEphemeral(true).queue();
                    return;
                }
                if (buttonId.startsWith("accept-")) {
                    this.plugin.setLoggedIn(player, true);
                    String ip = this.plugin.getPlayerIP(player);
                    if (ip != null) {
                        this.plugin.setIP(player, ip);
                    }
                    player.sendMessage(Rlogin.this.translateColorCodes(this.plugin.getConfig().getString("messages.login_successful")));
                    event.reply("\u0412\u0445\u043e\u0434 \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0451\u043d.").setEphemeral(true).queue();
                } else {
                    Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> player.kickPlayer(Rlogin.this.translateColorCodes(this.plugin.getConfig().getString("messages.login_2fa_rejected"))));
                    event.reply("\u0412\u0445\u043e\u0434 \u043e\u0442\u043a\u043b\u043e\u043d\u0451\u043d.").setEphemeral(true).queue();
                }
            }
        }

        @Override
        public void onMessageReceived(MessageReceivedEvent event) {
            if (event.getAuthor().isBot()) {
                return;
            }
            String message = event.getMessage().getContentRaw();
            String discordId = event.getAuthor().getId();
            for (Map.Entry<String, String> entry : Rlogin.this.pending2FACodes.entrySet()) {
                String playerName = entry.getKey();
                String code = entry.getValue();
                if (!message.equals(code)) continue;
                Rlogin.this.pending2FACodes.remove(playerName);
                Rlogin.this.enable2FA(playerName, discordId);
                Player player = Bukkit.getPlayerExact((String)playerName);
                if (player != null) {
                    player.sendMessage(Rlogin.this.translateColorCodes(Rlogin.this.getConfig().getString("messages.add2fa_successful")));
                }
                event.getChannel().sendMessage("2FA \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0432\u043a\u043b\u044e\u0447\u0435\u043d\u0430 \u0434\u043b\u044f " + playerName + ".").queue();
                return;
            }
            if (message.equalsIgnoreCase("/remove2fa")) {
                String playerName = null;
                for (String name : this.getDiscordIdMap().keySet()) {
                    if (!Rlogin.this.getDiscordId(name).equals(discordId)) continue;
                    playerName = name;
                    break;
                }
                if (playerName == null) {
                    event.getChannel().sendMessage("\u0412\u0430\u0448 Discord \u043d\u0435 \u043f\u0440\u0438\u0432\u044f\u0437\u0430\u043d \u043a \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0443 Minecraft.").queue();
                    return;
                }
                String string = Rlogin.this.generate2FACode();
                Rlogin.this.pendingRemove2FACodes.put(playerName, string);
                event.getChannel().sendMessage(Rlogin.this.getConfig().getString("messages.discord_remove2fa_code_sent").replace("%player%", playerName).replace("%code%", string)).queue();
                return;
            }
            event.getChannel().sendMessage(Rlogin.this.translateColorCodes(Rlogin.this.getConfig().getString("messages.discord_code_invalid"))).queue();
        }

        private Map<String, String> getDiscordIdMap() {
            HashMap<String, String> discordIds = new HashMap<String, String>();
            if (Rlogin.this.twoFaConfig.contains(Rlogin.TWO_FA_PATH)) {
                for (String key : Rlogin.this.twoFaConfig.getConfigurationSection(Rlogin.TWO_FA_PATH).getKeys(false)) {
                    discordIds.put(key, Rlogin.this.twoFaConfig.getString("2fa." + key));
                }
            }
            return discordIds;
        }
    }
}

