/*
 * Decompiled with CFR 0.152.
 */
package RASMI.rlogin.jda.jda.api.audio.hooks;

import RASMI.rlogin.jda.jda.api.audio.SpeakingMode;
import RASMI.rlogin.jda.jda.api.audio.hooks.ConnectionListener;
import RASMI.rlogin.jda.jda.api.audio.hooks.ConnectionStatus;
import RASMI.rlogin.jda.jda.api.entities.User;
import RASMI.rlogin.jda.jda.api.entities.UserSnowflake;
import java.util.EnumSet;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListenerProxy
implements ConnectionListener {
    private static final Logger log = LoggerFactory.getLogger(ListenerProxy.class);
    private volatile ConnectionListener listener = null;

    @Override
    public void onPing(long ping) {
        block4: {
            if (this.listener == null) {
                return;
            }
            ConnectionListener listener = this.listener;
            try {
                if (listener != null) {
                    listener.onPing(ping);
                }
            }
            catch (Throwable t) {
                log.error("The ConnectionListener encountered and uncaught exception", t);
                if (!(t instanceof Error)) break block4;
                throw (Error)t;
            }
        }
    }

    @Override
    public void onStatusChange(@Nonnull ConnectionStatus status) {
        block4: {
            if (this.listener == null) {
                return;
            }
            ConnectionListener listener = this.listener;
            try {
                if (listener != null) {
                    listener.onStatusChange(status);
                }
            }
            catch (Throwable t) {
                log.error("The ConnectionListener encountered and uncaught exception", t);
                if (!(t instanceof Error)) break block4;
                throw (Error)t;
            }
        }
    }

    @Override
    public void onUserSpeaking(@Nonnull User user, @Nonnull EnumSet<SpeakingMode> modes) {
        block4: {
            if (this.listener == null) {
                return;
            }
            ConnectionListener listener = this.listener;
            try {
                if (listener != null) {
                    listener.onUserSpeaking(user, modes);
                    listener.onUserSpeaking(user, modes.contains((Object)SpeakingMode.VOICE));
                    listener.onUserSpeaking(user, modes.contains((Object)SpeakingMode.VOICE), modes.contains((Object)SpeakingMode.SOUNDSHARE));
                }
            }
            catch (Throwable t) {
                log.error("The ConnectionListener encountered and uncaught exception", t);
                if (!(t instanceof Error)) break block4;
                throw (Error)t;
            }
        }
    }

    @Override
    public void onUserSpeakingModeUpdate(@Nonnull UserSnowflake user, @Nonnull EnumSet<SpeakingMode> modes) {
        block5: {
            if (this.listener == null) {
                return;
            }
            ConnectionListener listener = this.listener;
            try {
                if (listener != null) {
                    listener.onUserSpeakingModeUpdate(user, modes);
                    if (user instanceof User) {
                        listener.onUserSpeakingModeUpdate((User)user, modes);
                    }
                }
            }
            catch (Throwable t) {
                log.error("The ConnectionListener encountered and uncaught exception", t);
                if (!(t instanceof Error)) break block5;
                throw (Error)t;
            }
        }
    }

    public void setListener(ConnectionListener listener) {
        this.listener = listener;
    }

    public ConnectionListener getListener() {
        return this.listener;
    }
}

