/*
 * Decompiled with CFR 0.152.
 */
package RASMI.rlogin.jda.jda.api.sharding;

import RASMI.rlogin.jda.jda.internal.utils.Checks;
import java.util.concurrent.ExecutorService;
import java.util.function.IntFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface ThreadPoolProvider<T extends ExecutorService> {
    @Nullable
    public T provide(int var1);

    default public boolean shouldShutdownAutomatically(int shardId) {
        return false;
    }

    @Nonnull
    public static <T extends ExecutorService> LazySharedProvider<T> lazy(@Nonnull IntFunction<T> init) {
        Checks.notNull(init, "Initializer");
        return new LazySharedProvider<T>(init);
    }

    public static final class LazySharedProvider<T extends ExecutorService>
    implements ThreadPoolProvider<T> {
        private final IntFunction<T> initializer;
        private T pool;

        LazySharedProvider(@Nonnull IntFunction<T> initializer) {
            this.initializer = initializer;
        }

        public synchronized void init(int shardTotal) {
            if (this.pool == null) {
                this.pool = (ExecutorService)this.initializer.apply(shardTotal);
            }
        }

        public synchronized void shutdown() {
            if (this.pool != null) {
                this.pool.shutdown();
                this.pool = null;
            }
        }

        @Override
        @Nullable
        public synchronized T provide(int shardId) {
            return this.pool;
        }
    }
}

