/*
 * Decompiled with CFR 0.152.
 */
package RASMI.rlogin.jda.jda.internal.entities;

import RASMI.rlogin.jda.jda.api.JDA;
import RASMI.rlogin.jda.jda.api.entities.Guild;
import RASMI.rlogin.jda.jda.api.entities.Member;
import RASMI.rlogin.jda.jda.api.entities.ThreadMember;
import RASMI.rlogin.jda.jda.api.entities.User;
import RASMI.rlogin.jda.jda.api.entities.channel.concrete.ThreadChannel;
import RASMI.rlogin.jda.jda.internal.entities.channel.concrete.ThreadChannelImpl;
import RASMI.rlogin.jda.jda.internal.utils.EntityString;
import RASMI.rlogin.jda.jda.internal.utils.Helpers;
import java.time.OffsetDateTime;
import javax.annotation.Nonnull;

public class ThreadMemberImpl
implements ThreadMember {
    private final JDA api;
    private final ThreadChannelImpl thread;
    private Member member;
    private long joinedTimestamp;

    public ThreadMemberImpl(Member member, ThreadChannelImpl thread2) {
        this.api = member.getJDA();
        this.member = member;
        this.thread = thread2;
    }

    @Override
    @Nonnull
    public JDA getJDA() {
        return this.api;
    }

    @Override
    @Nonnull
    public Guild getGuild() {
        return this.thread.getGuild();
    }

    @Override
    @Nonnull
    public ThreadChannel getThread() {
        return this.thread;
    }

    @Override
    @Nonnull
    public User getUser() {
        return this.member.getUser();
    }

    @Override
    @Nonnull
    public Member getMember() {
        return this.member;
    }

    @Override
    @Nonnull
    public OffsetDateTime getTimeJoined() {
        return Helpers.toOffset(this.joinedTimestamp);
    }

    @Override
    @Nonnull
    public String getAsMention() {
        return this.member.getAsMention();
    }

    @Override
    public long getIdLong() {
        return this.member.getIdLong();
    }

    public ThreadMemberImpl setJoinedTimestamp(long joinedTimestamp) {
        this.joinedTimestamp = joinedTimestamp;
        return this;
    }

    public String toString() {
        return new EntityString(this).addMetadata("member", this.getMember()).toString();
    }
}

