/*
 * Decompiled with CFR 0.152.
 */
package RASMI.rlogin.jda.jda.internal.entities.channel.concrete;

import RASMI.rlogin.jda.jda.api.Permission;
import RASMI.rlogin.jda.jda.api.entities.Guild;
import RASMI.rlogin.jda.jda.api.entities.Member;
import RASMI.rlogin.jda.jda.api.entities.PermissionOverride;
import RASMI.rlogin.jda.jda.api.entities.Webhook;
import RASMI.rlogin.jda.jda.api.entities.channel.ChannelType;
import RASMI.rlogin.jda.jda.api.entities.channel.concrete.Category;
import RASMI.rlogin.jda.jda.api.entities.channel.concrete.NewsChannel;
import RASMI.rlogin.jda.jda.api.entities.channel.middleman.GuildChannel;
import RASMI.rlogin.jda.jda.api.entities.channel.unions.DefaultGuildChannelUnion;
import RASMI.rlogin.jda.jda.api.managers.channel.concrete.NewsChannelManager;
import RASMI.rlogin.jda.jda.api.requests.RestAction;
import RASMI.rlogin.jda.jda.api.requests.Route;
import RASMI.rlogin.jda.jda.api.requests.restaction.ChannelAction;
import RASMI.rlogin.jda.jda.api.utils.data.DataObject;
import RASMI.rlogin.jda.jda.internal.entities.GuildImpl;
import RASMI.rlogin.jda.jda.internal.entities.channel.middleman.AbstractStandardGuildMessageChannelImpl;
import RASMI.rlogin.jda.jda.internal.managers.channel.concrete.NewsChannelManagerImpl;
import RASMI.rlogin.jda.jda.internal.requests.RestActionImpl;
import RASMI.rlogin.jda.jda.internal.utils.Checks;
import RASMI.rlogin.jda.jda.internal.utils.Helpers;
import java.util.List;
import javax.annotation.Nonnull;

public class NewsChannelImpl
extends AbstractStandardGuildMessageChannelImpl<NewsChannelImpl>
implements NewsChannel,
DefaultGuildChannelUnion {
    public NewsChannelImpl(long id, GuildImpl guild) {
        super(id, guild);
    }

    @Override
    @Nonnull
    public ChannelType getType() {
        return ChannelType.NEWS;
    }

    @Override
    @Nonnull
    public List<Member> getMembers() {
        return this.getGuild().getMembersView().stream().filter(m -> m.hasPermission((GuildChannel)this, Permission.VIEW_CHANNEL)).collect(Helpers.toUnmodifiableList());
    }

    @Override
    @Nonnull
    public RestAction<Webhook.WebhookReference> follow(@Nonnull String targetChannelId) {
        Checks.notNull(targetChannelId, "Target Channel ID");
        Route.CompiledRoute route = Route.Channels.FOLLOW_CHANNEL.compile(this.getId());
        DataObject body = DataObject.empty().put("webhook_channel_id", targetChannelId);
        return new RestActionImpl<Webhook.WebhookReference>(this.getJDA(), route, body, (response, request) -> {
            DataObject json = response.getObject();
            return new Webhook.WebhookReference(request.getJDA(), json.getUnsignedLong("webhook_id"), json.getUnsignedLong("channel_id"));
        });
    }

    @Override
    @Nonnull
    public ChannelAction<NewsChannel> createCopy(@Nonnull Guild guild) {
        Checks.notNull(guild, "Guild");
        ChannelAction<NewsChannel> action = guild.createNewsChannel(this.name).setNSFW(this.nsfw).setTopic(this.topic);
        if (guild.equals(this.getGuild())) {
            Category parent = this.getParentCategory();
            if (parent != null) {
                action.setParent(parent);
            }
            for (PermissionOverride o : this.overrides.valueCollection()) {
                if (o.isMemberOverride()) {
                    action.addMemberPermissionOverride(o.getIdLong(), o.getAllowedRaw(), o.getDeniedRaw());
                    continue;
                }
                action.addRolePermissionOverride(o.getIdLong(), o.getAllowedRaw(), o.getDeniedRaw());
            }
        }
        return action;
    }

    @Override
    @Nonnull
    public NewsChannelManager getManager() {
        return new NewsChannelManagerImpl(this);
    }
}

