/*
 * Decompiled with CFR 0.152.
 */
package RASMI.rlogin.jda.jda.internal.interactions.component;

import RASMI.rlogin.jda.jda.api.entities.Guild;
import RASMI.rlogin.jda.jda.api.entities.Message;
import RASMI.rlogin.jda.jda.api.entities.channel.unions.MessageChannelUnion;
import RASMI.rlogin.jda.jda.api.interactions.components.ComponentInteraction;
import RASMI.rlogin.jda.jda.api.interactions.modals.Modal;
import RASMI.rlogin.jda.jda.api.requests.restaction.interactions.ModalCallbackAction;
import RASMI.rlogin.jda.jda.api.requests.restaction.interactions.ReplyCallbackAction;
import RASMI.rlogin.jda.jda.api.utils.data.DataObject;
import RASMI.rlogin.jda.jda.internal.JDAImpl;
import RASMI.rlogin.jda.jda.internal.entities.ReceivedMessage;
import RASMI.rlogin.jda.jda.internal.interactions.DeferrableInteractionImpl;
import RASMI.rlogin.jda.jda.internal.requests.restaction.interactions.MessageEditCallbackActionImpl;
import RASMI.rlogin.jda.jda.internal.requests.restaction.interactions.ModalCallbackActionImpl;
import RASMI.rlogin.jda.jda.internal.requests.restaction.interactions.ReplyCallbackActionImpl;
import RASMI.rlogin.jda.jda.internal.utils.Checks;
import javax.annotation.Nonnull;

public abstract class ComponentInteractionImpl
extends DeferrableInteractionImpl
implements ComponentInteraction {
    protected final String customId;
    protected final Message message;
    protected final long messageId;

    public ComponentInteractionImpl(JDAImpl jda, DataObject data) {
        super(jda, data);
        this.customId = data.getObject("data").getString("custom_id");
        DataObject messageJson = data.getObject("message");
        this.messageId = messageJson.getUnsignedLong("id");
        if (messageJson.isNull("type")) {
            this.message = null;
        } else {
            Guild guild = this.getGuild();
            MessageChannelUnion channel = this.getChannel();
            this.message = channel != null ? jda.getEntityBuilder().createMessageWithChannel(messageJson, channel, false) : jda.getEntityBuilder().createMessageWithLookup(messageJson, guild, false);
            ((ReceivedMessage)this.message).withHook(this.getHook());
        }
    }

    @Override
    public MessageChannelUnion getChannel() {
        return (MessageChannelUnion)super.getChannel();
    }

    @Override
    @Nonnull
    public String getComponentId() {
        return this.customId;
    }

    @Override
    @Nonnull
    public Message getMessage() {
        return this.message;
    }

    @Override
    public long getMessageIdLong() {
        return this.messageId;
    }

    @Override
    @Nonnull
    public MessageEditCallbackActionImpl deferEdit() {
        return new MessageEditCallbackActionImpl(this.hook);
    }

    @Override
    @Nonnull
    public ReplyCallbackAction deferReply() {
        return new ReplyCallbackActionImpl(this.hook);
    }

    @Override
    @Nonnull
    public ModalCallbackAction replyModal(@Nonnull Modal modal) {
        Checks.notNull(modal, "Modal");
        return new ModalCallbackActionImpl(this, modal);
    }
}

