/*
 * Decompiled with CFR 0.152.
 */
package RASMI.rlogin.jda.jda.api.entities.channel.concrete;

import RASMI.rlogin.jda.jda.api.Permission;
import RASMI.rlogin.jda.jda.api.entities.Guild;
import RASMI.rlogin.jda.jda.api.entities.Member;
import RASMI.rlogin.jda.jda.api.entities.StageInstance;
import RASMI.rlogin.jda.jda.api.entities.channel.attribute.IAgeRestrictedChannel;
import RASMI.rlogin.jda.jda.api.entities.channel.attribute.ISlowmodeChannel;
import RASMI.rlogin.jda.jda.api.entities.channel.attribute.IWebhookContainer;
import RASMI.rlogin.jda.jda.api.entities.channel.middleman.AudioChannel;
import RASMI.rlogin.jda.jda.api.entities.channel.middleman.GuildChannel;
import RASMI.rlogin.jda.jda.api.entities.channel.middleman.GuildMessageChannel;
import RASMI.rlogin.jda.jda.api.entities.channel.middleman.StandardGuildChannel;
import RASMI.rlogin.jda.jda.api.exceptions.InsufficientPermissionException;
import RASMI.rlogin.jda.jda.api.managers.channel.concrete.StageChannelManager;
import RASMI.rlogin.jda.jda.api.requests.RestAction;
import RASMI.rlogin.jda.jda.api.requests.restaction.ChannelAction;
import RASMI.rlogin.jda.jda.api.requests.restaction.StageInstanceAction;
import RASMI.rlogin.jda.jda.internal.requests.restaction.StageInstanceActionImpl;
import RASMI.rlogin.jda.jda.internal.utils.Checks;
import java.util.EnumSet;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface StageChannel
extends StandardGuildChannel,
GuildMessageChannel,
AudioChannel,
IWebhookContainer,
IAgeRestrictedChannel,
ISlowmodeChannel {
    public static final int MAX_USERLIMIT = 10000;

    @Nullable
    public StageInstance getStageInstance();

    @Nonnull
    @CheckReturnValue
    default public StageInstanceAction createStageInstance(@Nonnull String topic) {
        EnumSet<Permission> permissions = this.getGuild().getSelfMember().getPermissions(this);
        EnumSet<Permission> required = EnumSet.of(Permission.MANAGE_CHANNEL, Permission.VOICE_MUTE_OTHERS, Permission.VOICE_MOVE_OTHERS);
        for (Permission perm : required) {
            if (permissions.contains((Object)perm)) continue;
            throw new InsufficientPermissionException(this, perm, "You must be a stage moderator to create a stage instance! Missing Permission: " + (Object)((Object)perm));
        }
        return new StageInstanceActionImpl(this).setTopic(topic);
    }

    default public boolean isModerator(@Nonnull Member member) {
        Checks.notNull(member, "Member");
        return member.hasPermission((GuildChannel)this, Permission.MANAGE_CHANNEL, Permission.VOICE_MUTE_OTHERS, Permission.VOICE_MOVE_OTHERS);
    }

    @Nonnull
    public ChannelAction<StageChannel> createCopy(@Nonnull Guild var1);

    @Nonnull
    default public ChannelAction<StageChannel> createCopy() {
        return this.createCopy(this.getGuild());
    }

    @Override
    @Nonnull
    public StageChannelManager getManager();

    @Nonnull
    @CheckReturnValue
    public RestAction<Void> requestToSpeak();

    @Nonnull
    @CheckReturnValue
    public RestAction<Void> cancelRequestToSpeak();
}

