/*
 * Decompiled with CFR 0.152.
 */
package RASMI.rlogin.jda.jda.api.utils;

import RASMI.rlogin.jda.jda.api.utils.FileProxy;
import RASMI.rlogin.jda.jda.internal.utils.Checks;
import RASMI.rlogin.jda.jda.internal.utils.FutureUtil;
import RASMI.rlogin.jda.jda.internal.utils.IOUtil;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

public class ImageProxy
extends FileProxy {
    public ImageProxy(@Nonnull String url) {
        super(url);
    }

    @Nonnull
    public String getUrl(int size) {
        Checks.positive(size, "Image size");
        return IOUtil.addQuery(this.getUrl(), "size", size);
    }

    @Nonnull
    public CompletableFuture<InputStream> download(int size) {
        return this.download(this.getUrl(size));
    }

    @Nonnull
    public CompletableFuture<Path> downloadToPath(int size) {
        return this.downloadToPath(this.getUrl(size));
    }

    @Nonnull
    public CompletableFuture<File> downloadToFile(@Nonnull File file, int size) {
        Checks.notNull(file, "File");
        CompletableFuture<Path> downloadToPathFuture = this.downloadToPath(this.getUrl(size), file.toPath());
        return FutureUtil.thenApplyCancellable(downloadToPathFuture, Path::toFile);
    }

    @Nonnull
    public CompletableFuture<Path> downloadToPath(@Nonnull Path path, int size) {
        Checks.notNull(path, "Path");
        return this.downloadToPath(this.getUrl(size), path);
    }
}

